/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.redis;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface DistributedLocker {
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    public static final int DEFAULT_WAIT_TIME = 5;
    public static final int DEFAULT_LEASE_TIME = 5;

    default public <V> V tryLock(String lockKey, Supplier<V> supplier) {
        return this.tryLock(lockKey, 5, supplier);
    }

    default public <V> V tryLock(String lockKey, int waitTime, Supplier<V> supplier) {
        return this.tryLock(lockKey, waitTime, 5, supplier);
    }

    default public <V> V tryLock(String lockKey, int waitTime, int leaseTime, Supplier<V> supplier) {
        return this.tryLock(lockKey, waitTime, leaseTime, DEFAULT_TIME_UNIT, supplier);
    }

    public boolean tryLock(String var1, int var2, int var3, TimeUnit var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <V> V tryLock(String lockKey, int waitTime, int leaseTime, TimeUnit unit, Supplier<V> supplier) {
        if (this.tryLock(lockKey, waitTime, leaseTime, unit)) {
            try {
                V v = supplier.get();
                return v;
            }
            finally {
                this.unlock(lockKey);
            }
        }
        return null;
    }

    public void unlock(String var1);
}

