/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.redis;

import cn.hiboot.mcn.autoconfigure.config.ConfigProperties;
import cn.hiboot.mcn.autoconfigure.redis.DistributedLocker;
import cn.hiboot.mcn.core.exception.ServiceException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;

public class RedisDistributedLocker
implements DistributedLocker {
    private final StringRedisTemplate redisTemplate;
    private final DefaultRedisScript<Long> redisScript;

    public RedisDistributedLocker(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
        this.redisScript = new DefaultRedisScript();
        this.redisScript.setResultType(Long.class);
        this.redisScript.setScriptSource((ScriptSource)new ResourceScriptSource((Resource)ConfigProperties.createResource("unlock.lua", DistributedLocker.class)));
    }

    @Override
    public boolean tryLock(String lockKey, int waitTime, int leaseTime, TimeUnit unit) {
        Boolean success = this.setIfAbsent(lockKey, leaseTime, unit);
        long nanoWaitForLock = unit.toNanos(5L);
        long start = System.nanoTime();
        while (!(System.nanoTime() - start >= nanoWaitForLock || success != null && success.booleanValue() || (success = this.setIfAbsent(lockKey, leaseTime, unit)) != null && success.booleanValue())) {
        }
        if (success != null && success.booleanValue()) {
            return true;
        }
        throw ServiceException.newInstance((String)(waitTime + "s\u5185\u83b7\u53d6\u9501\u8d85\u65f6"));
    }

    private Boolean setIfAbsent(String lockKey, int leaseTime, TimeUnit unit) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)lockKey, (long)leaseTime, unit);
    }

    @Override
    public void unlock(String lockKey) {
        this.redisTemplate.execute(this.redisScript, Collections.singletonList(lockKey), new Object[]{lockKey});
    }
}

