/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.redis;

import cn.hiboot.mcn.autoconfigure.redis.DistributedLocker;
import cn.hiboot.mcn.autoconfigure.redis.DistributedLockerAspect;
import cn.hiboot.mcn.autoconfigure.redis.RedisDistributedLocker;
import cn.hiboot.mcn.autoconfigure.redis.RepeatCommitAspect;
import cn.hiboot.mcn.autoconfigure.web.filter.common.JsonRequestHelper;
import cn.hiboot.mcn.autoconfigure.web.filter.common.servlet.RequestPayloadRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.StringRedisTemplate;

@AutoConfiguration(after={RedisAutoConfiguration.class})
@ConditionalOnClass(value={RedisOperations.class})
public class RedisToolAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={StringRedisTemplate.class})
    public DistributedLocker distributedLocker(StringRedisTemplate redisTemplate) {
        return new RedisDistributedLocker(redisTemplate);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Aspect.class})
    @Import(value={JsonDataConveyFilter.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnProperty(prefix="mcn.repeat", name={"enable"}, havingValue="true")
    protected static class RepeatCommitAspectConfiguration {
        protected RepeatCommitAspectConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={StringRedisTemplate.class})
        public RepeatCommitAspect repeatCommitAspect(StringRedisTemplate redisTemplate) {
            return new RepeatCommitAspect(redisTemplate);
        }

        protected static class JsonDataConveyFilter
        implements Filter {
            protected JsonDataConveyFilter() {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                if (JsonRequestHelper.isJsonRequest(httpServletRequest)) {
                    request = new RequestPayloadRequestWrapper(httpServletRequest);
                }
                chain.doFilter(request, response);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Aspect.class})
    protected static class DistributedLockerAspectConfiguration {
        protected DistributedLockerAspectConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={DistributedLocker.class})
        public DistributedLockerAspect distributedLockerAspect(DistributedLocker distributedLocker) {
            return new DistributedLockerAspect(distributedLocker);
        }
    }
}

