/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.redis;

import cn.hiboot.mcn.autoconfigure.redis.annotation.RepeatCommit;
import cn.hiboot.mcn.autoconfigure.web.filter.common.JsonRequestHelper;
import cn.hiboot.mcn.core.exception.ServiceException;
import cn.hiboot.mcn.core.util.JacksonUtils;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.StreamUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class RepeatCommitAspect {
    private static final String REQUEST_HASH_PREFIX = "request:hash:";
    private final StringRedisTemplate redisTemplate;

    public RepeatCommitAspect(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Pointcut(value="@annotation(repeatCommit)")
    public void pointCut(RepeatCommit repeatCommit) {
    }

    @Around(value="pointCut(repeatCommit)", argNames="p,repeatCommit")
    public Object around(ProceedingJoinPoint p, RepeatCommit repeatCommit) throws Throwable {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = requestAttributes.getRequest();
            StringBuilder requestContent = new StringBuilder();
            requestContent.append(request.getMethod());
            requestContent.append(request.getServletPath());
            Map parameterMap = request.getParameterMap();
            if (!CollectionUtils.isEmpty((Map)parameterMap)) {
                requestContent.append(JacksonUtils.toJson((Object)parameterMap));
            }
            if (JsonRequestHelper.isJsonRequest(request)) {
                requestContent.append(StreamUtils.copyToString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8));
            }
            String hash = DigestUtils.md5DigestAsHex((byte[])requestContent.toString().getBytes(StandardCharsets.UTF_8));
            String key = REQUEST_HASH_PREFIX + hash;
            Boolean status = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, (long)repeatCommit.value(), TimeUnit.MILLISECONDS);
            if (status == null || !status.booleanValue()) {
                throw ServiceException.newInstance((String)"\u91cd\u590d\u63d0\u4ea4");
            }
        }
        return p.proceed();
    }
}

