/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.sql;

import cn.hiboot.mcn.autoconfigure.sql.SqlInitProperties;
import cn.hiboot.mcn.core.util.SpringBeanUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.sql.init.SqlDataSourceScriptDatabaseInitializer;
import org.springframework.boot.autoconfigure.sql.init.SqlInitializationProperties;
import org.springframework.boot.sql.init.DatabaseInitializationMode;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class SqlInitCreator {
    private static final String OPTIONAL_LOCATION_PREFIX = "optional:";

    SqlInitCreator() {
    }

    static CustomSqlDataSourceScriptDatabaseInitializer create() {
        SqlInitProperties sqlInitProperties = (SqlInitProperties)SpringBeanUtils.getBean(SqlInitProperties.class);
        SqlInitializationProperties properties = (SqlInitializationProperties)SpringBeanUtils.getBean(SqlInitializationProperties.class);
        CustomDatabaseInitializationSettings settings = new CustomDatabaseInitializationSettings();
        settings.setSchemaLocations(SqlInitCreator.scriptLocations(properties.getSchemaLocations(), sqlInitProperties.getDir(), "schema", properties.getPlatform()));
        settings.setScriptLocations(SqlInitCreator.scriptLocations(sqlInitProperties.getLocations(), sqlInitProperties.getDir(), "other", properties.getPlatform()));
        settings.setDataLocations(SqlInitCreator.scriptLocations(properties.getDataLocations(), sqlInitProperties.getDir(), "data", properties.getPlatform()));
        settings.setOtherSeparator(sqlInitProperties.getSeparator());
        settings.setContinueOnError(properties.isContinueOnError());
        settings.setSeparator(properties.getSeparator());
        settings.setEncoding(properties.getEncoding());
        settings.setMode(properties.getMode());
        settings.setInitDdName(sqlInitProperties.getInitDbName());
        return new CustomSqlDataSourceScriptDatabaseInitializer((DataSource)SpringBeanUtils.getBean(DataSource.class), settings);
    }

    static List<String> scriptLocations(List<String> locations, String dir, String fallback, String platform) {
        if (locations != null) {
            return locations;
        }
        if (StringUtils.hasLength((String)dir)) {
            fallback = dir + "/" + fallback;
        }
        ArrayList<String> fallbackLocations = new ArrayList<String>();
        fallbackLocations.add("optional:classpath*:" + fallback + "-" + platform + ".sql");
        fallbackLocations.add("optional:classpath*:" + fallback + ".sql");
        return fallbackLocations;
    }

    private static class ScriptLocationResolver {
        private final ResourcePatternResolver resourcePatternResolver;

        ScriptLocationResolver(ResourceLoader resourceLoader) {
            this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        }

        private List<Resource> resolve(String location) throws IOException {
            ArrayList<Resource> resources = new ArrayList<Resource>(Arrays.asList(this.resourcePatternResolver.getResources(location)));
            resources.sort((r1, r2) -> {
                try {
                    return r1.getURL().toString().compareTo(r2.getURL().toString());
                }
                catch (IOException ex) {
                    return 0;
                }
            });
            return resources;
        }
    }

    private static class CustomDatabaseInitializationSettings
    extends DatabaseInitializationSettings {
        private List<String> scriptLocations;
        private String otherSeparator = ";";
        private String initDdName;

        private CustomDatabaseInitializationSettings() {
        }

        public List<String> getScriptLocations() {
            return this.scriptLocations;
        }

        public void setScriptLocations(List<String> scriptLocations) {
            this.scriptLocations = scriptLocations;
        }

        public String getOtherSeparator() {
            return this.otherSeparator;
        }

        public void setOtherSeparator(String otherSeparator) {
            this.otherSeparator = otherSeparator;
        }

        public String getInitDdName() {
            return this.initDdName;
        }

        public void setInitDdName(String initDdName) {
            this.initDdName = initDdName;
        }
    }

    private static class CustomSqlDataSourceScriptDatabaseInitializer
    extends SqlDataSourceScriptDatabaseInitializer {
        private final CustomDatabaseInitializationSettings settings;

        public CustomSqlDataSourceScriptDatabaseInitializer(DataSource dataSource, CustomDatabaseInitializationSettings settings) {
            super(dataSource, (DatabaseInitializationSettings)settings);
            this.settings = settings;
        }

        public boolean initializeDatabase() {
            ScriptLocationResolver locationResolver = new ScriptLocationResolver((ResourceLoader)SpringBeanUtils.getApplicationContext());
            this.createDatabase((DataSourceProperties)SpringBeanUtils.getBean(DataSourceProperties.class));
            boolean initialized = this.applySchemaScripts(locationResolver);
            boolean other = this.applyOtherScripts(locationResolver);
            return this.applyDataScripts(locationResolver) || other || initialized;
        }

        private void createDatabase(DataSourceProperties properties) {
            String initDdName = this.settings.getInitDdName();
            if (ObjectUtils.isEmpty((Object)initDdName)) {
                return;
            }
            try {
                String url = properties.getUrl();
                int qPos = url.indexOf(63);
                String urlServer = url;
                if (qPos != -1) {
                    urlServer = url.substring(0, qPos);
                }
                int slash = urlServer.lastIndexOf(47);
                String dbName = urlServer.substring(slash + 1);
                url = urlServer.substring(0, slash + 1) + initDdName;
                try (Connection con = DriverManager.getConnection(url, properties.getUsername(), properties.getPassword());){
                    con.prepareStatement("CREATE DATABASE ".concat(dbName)).executeUpdate();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        private boolean applySchemaScripts(ScriptLocationResolver locationResolver) {
            return this.applyScripts(this.settings.getSchemaLocations(), "schema", locationResolver, null);
        }

        private boolean applyOtherScripts(ScriptLocationResolver locationResolver) {
            return this.applyScripts(this.settings.getScriptLocations(), "other", locationResolver, this.settings.getOtherSeparator());
        }

        private boolean applyDataScripts(ScriptLocationResolver locationResolver) {
            return this.applyScripts(this.settings.getDataLocations(), "data", locationResolver, null);
        }

        private boolean applyScripts(List<String> locations, String type, ScriptLocationResolver locationResolver, String separator) {
            List<Resource> scripts = this.getScripts(locations, type, locationResolver);
            if (!scripts.isEmpty() && this.isEnabled()) {
                this.runScripts(scripts, separator);
                return true;
            }
            return false;
        }

        private boolean isEnabled() {
            if (this.settings.getMode() == DatabaseInitializationMode.NEVER) {
                return false;
            }
            return this.settings.getMode() == DatabaseInitializationMode.ALWAYS || this.isEmbeddedDatabase();
        }

        private List<Resource> getScripts(List<String> locations, String type, ScriptLocationResolver locationResolver) {
            if (CollectionUtils.isEmpty(locations)) {
                return Collections.emptyList();
            }
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String location : locations) {
                boolean optional = location.startsWith(SqlInitCreator.OPTIONAL_LOCATION_PREFIX);
                if (optional) {
                    location = location.substring(SqlInitCreator.OPTIONAL_LOCATION_PREFIX.length());
                }
                for (Resource resource : this.doGetResources(location, locationResolver)) {
                    if (resource.exists()) {
                        resources.add(resource);
                        continue;
                    }
                    if (optional) continue;
                    throw new IllegalStateException("No " + type + " scripts found at location '" + location + "'");
                }
            }
            return resources;
        }

        private List<Resource> doGetResources(String location, ScriptLocationResolver locationResolver) {
            try {
                return locationResolver.resolve(location);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to load resources from " + location, ex);
            }
        }

        private void runScripts(List<Resource> resources, String separator) {
            this.runScripts(resources, this.settings.isContinueOnError(), separator == null ? this.settings.getSeparator() : separator, this.settings.getEncoding());
        }
    }
}

