/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.validator;

import cn.hiboot.mcn.core.util.SpringBeanUtils;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;

public abstract class BeanValidator {
    private static volatile Validator validator;

    public static <T> void validate(T object) {
        Validator validator = BeanValidator.getValidator();
        Set constraintViolations = validator.validate(object, new Class[0]);
        if (constraintViolations != null && !constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    private static Validator getValidator() {
        if (validator == null) {
            try {
                validator = (Validator)SpringBeanUtils.getBean(Validator.class);
            }
            catch (Exception e) {
                validator = Validation.buildDefaultValidatorFactory().getValidator();
            }
        }
        return validator;
    }
}

