/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.validator;

import cn.hiboot.mcn.autoconfigure.validator.LocalValidatorCustomizer;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.validation.ValidationAutoConfiguration;
import org.springframework.boot.validation.MessageInterpolatorFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@AutoConfiguration(before={ValidationAutoConfiguration.class})
@ConditionalOnClass(value={ExecutableValidator.class})
@ConditionalOnResource(resources={"classpath:META-INF/services/javax.validation.spi.ValidationProvider"})
public class ValidatorAutoConfiguration {
    private final ObjectProvider<LocalValidatorCustomizer> customizers;

    public ValidatorAutoConfiguration(ObjectProvider<LocalValidatorCustomizer> customizers) {
        this.customizers = customizers;
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(value={Validator.class})
    public LocalValidatorFactoryBean validator() {
        LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
        MessageInterpolatorFactory interpolatorFactory = new MessageInterpolatorFactory();
        factoryBean.setMessageInterpolator(interpolatorFactory.getObject());
        factoryBean.getValidationPropertyMap().put("hibernate.validator.fail_fast", "true");
        for (LocalValidatorCustomizer localValidatorCustomizer : this.customizers) {
            localValidatorCustomizer.customize(factoryBean);
        }
        return factoryBean;
    }
}

