/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.exception.error;

import cn.hiboot.mcn.autoconfigure.config.ConfigProperties;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.View;

public class DefaultErrorView
implements View {
    private final Logger log = LoggerFactory.getLogger(DefaultErrorView.class);
    private static final MediaType TEXT_HTML_UTF8 = new MediaType("text", "html", StandardCharsets.UTF_8);
    private final ServerProperties serverProperties;

    public DefaultErrorView(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (response.isCommitted()) {
            String message = this.getMessage(model);
            this.log.error(message);
            return;
        }
        response.setContentType(TEXT_HTML_UTF8.toString());
        String basePath = this.serverProperties.getServlet().getContextPath();
        response.getWriter().append(ConfigProperties.errorView(model, basePath));
    }

    private String getMessage(Map<String, ?> model) {
        Object path = model.get("path");
        String message = "Cannot render error page for request [" + path + "]";
        if (model.get("message") != null) {
            message = message + " and exception [" + model.get("message") + "]";
        }
        message = message + " as the response has already been committed.";
        message = message + " As a result, the response may have the wrong status code.";
        return message;
    }

    public String getContentType() {
        return "text/html";
    }
}

