/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.exception.error;

import cn.hiboot.mcn.core.exception.ExceptionKeys;
import cn.hiboot.mcn.core.model.result.RestResp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class ErrorPageController
extends BasicErrorController {
    @Value(value="${http.error.override:true}")
    private boolean overrideHttpError;

    public ErrorPageController(ErrorAttributes errorAttributes, ErrorProperties errorProperties, List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, errorProperties, errorViewResolvers);
    }

    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        ResponseEntity error = super.error(request);
        if (this.overrideHttpError) {
            int statusCode = error.getStatusCodeValue();
            int code = ExceptionKeys.mappingCode((Integer)statusCode);
            RestResp resp = RestResp.error((Integer)code);
            HashMap<String, Object> rs = new HashMap<String, Object>();
            rs.put("ActionStatus", resp.getActionStatus());
            rs.put("ErrorCode", resp.getErrorCode());
            rs.put("ErrorInfo", resp.getErrorInfo());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/json;charset=UTF-8"));
            return new ResponseEntity(rs, (MultiValueMap)headers, HttpStatus.valueOf((int)200));
        }
        return error;
    }
}

