/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.exception.handler;

import cn.hiboot.mcn.autoconfigure.web.exception.ExceptionProperties;
import cn.hiboot.mcn.autoconfigure.web.exception.ExceptionResolver;
import cn.hiboot.mcn.autoconfigure.web.exception.GenericExceptionResolver;
import cn.hiboot.mcn.autoconfigure.web.exception.HttpStatusCodeResolver;
import cn.hiboot.mcn.autoconfigure.web.exception.handler.ExceptionHandler;
import cn.hiboot.mcn.autoconfigure.web.exception.handler.ValidationErrorBean;
import cn.hiboot.mcn.autoconfigure.web.exception.handler.ValidationExceptionHandler;
import cn.hiboot.mcn.core.exception.BaseException;
import cn.hiboot.mcn.core.exception.ErrorMsg;
import cn.hiboot.mcn.core.model.result.RestResp;
import cn.hiboot.mcn.core.util.McnUtils;
import cn.hiboot.mcn.core.util.SpringBeanUtils;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.server.ResponseStatusException;

public class DefaultExceptionHandler
implements ExceptionHandler {
    private final Logger log = LoggerFactory.getLogger(DefaultExceptionHandler.class);
    private static final int DEFAULT_ERROR_CODE = 999998;
    private static final Map<Class<?>, List<ExceptionResolver<Throwable>>> exceptionResolverCache = new ConcurrentHashMap();
    private static final Map<Class<?>, ResolvableType> exceptionResolverTypeCache = new ConcurrentReferenceHashMap();
    private final boolean validationExceptionPresent;
    private final String basePackage;
    private final boolean overrideHttpError;
    private final ExceptionProperties properties;
    private final String[] exceptionResolverNames;
    private final ApplicationContext applicationContext;
    private final ObjectProvider<HttpStatusCodeResolver> httpStatusCodeResolvers;

    protected DefaultExceptionHandler(ExceptionProperties properties) {
        this.properties = properties;
        this.validationExceptionPresent = ClassUtils.isPresent((String)"javax.validation.ValidationException", (ClassLoader)this.getClass().getClassLoader());
        this.applicationContext = SpringBeanUtils.getApplicationContext();
        this.httpStatusCodeResolvers = this.applicationContext.getBeanProvider(HttpStatusCodeResolver.class);
        this.exceptionResolverNames = this.applicationContext.getBeanNamesForType(ExceptionResolver.class);
        this.basePackage = this.applicationContext.getEnvironment().getProperty("app.base-package");
        this.overrideHttpError = (Boolean)this.applicationContext.getEnvironment().getProperty("http.error.override", Boolean.class, (Object)true);
    }

    @Override
    public ExceptionProperties config() {
        return this.properties;
    }

    @Override
    public RestResp<Throwable> handleException(Throwable exception) {
        String message;
        ExceptionResolver<Throwable> exceptionResolver;
        RestResp resp = null;
        Class<?> exClass = exception.getClass();
        List<ExceptionResolver<Throwable>> exceptionResolvers = exceptionResolverCache.get(exClass);
        if (exceptionResolvers == null) {
            exceptionResolvers = Arrays.stream(this.exceptionResolverNames).map(s -> this.supportsExceptionType((String)s, (Class<? extends Throwable>)exClass)).filter(Objects::nonNull).collect(Collectors.toList());
            exceptionResolverCache.put(exClass, exceptionResolvers);
        }
        Iterator<ExceptionResolver<Throwable>> iterator = exceptionResolvers.iterator();
        while (iterator.hasNext() && (resp = (exceptionResolver = iterator.next()).resolve(exception)) == null) {
        }
        if (Objects.isNull(resp)) {
            RestResp<Object> rs = this.doHandleException(exception);
            resp = RestResp.error((Integer)rs.getErrorCode(), (String)rs.getErrorInfo());
        }
        if (this.properties.isOverrideExMsg() && Objects.nonNull(message = this.properties.getErrorCodeMsg().get(resp.getErrorCode()))) {
            resp.setErrorInfo(message);
        }
        this.logError(exception);
        return resp;
    }

    private RestResp<Object> doHandleException(Throwable exception) {
        Integer error;
        Integer errorCode = 999998;
        List<ValidationErrorBean> data = null;
        if (exception instanceof BaseException) {
            errorCode = ((BaseException)exception).getCode();
        } else if (exception instanceof MethodArgumentTypeMismatchException) {
            errorCode = 300008;
        } else if (exception instanceof MaxUploadSizeExceededException) {
            errorCode = 300007;
        } else if (exception instanceof BindException) {
            errorCode = 300001;
            BindException ex = (BindException)exception;
            data = this.dealBindingResult(ex.getBindingResult());
        } else if (this.validationExceptionPresent && ValidationExceptionHandler.support(exception)) {
            errorCode = 300001;
            data = ValidationExceptionHandler.handle(exception);
        } else if (exception instanceof HttpMessageNotReadableException || exception instanceof InvalidFormatException) {
            errorCode = 300002;
        } else if (exception instanceof VirtualMachineError) {
            errorCode = 800500;
            this.handleError((Error)exception.getCause());
        } else if (this.overrideHttpError && (error = (Integer)this.httpStatusCodeResolvers.orderedStream().map(resolver -> resolver.resolve(exception)).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
            errorCode = error;
        }
        String msg = this.properties.isReturnOriginExMsg() ? this.getMessage(exception) : ErrorMsg.getErrorMsg((Integer)this.getErrorCode(errorCode));
        RestResp resp = RestResp.error((Integer)errorCode, (String)msg);
        if (McnUtils.isNotNullAndEmpty(data)) {
            if (this.properties.isValidateResultToErrorInfo()) {
                ValidationErrorBean validationErrorBean = data.get(0);
                String message = validationErrorBean.getMessage();
                resp.setErrorInfo(this.properties.isAppendField() ? validationErrorBean.getPath().concat(message) : message);
            }
            if (this.properties.isReturnValidateResult()) {
                resp.setData(data);
            }
        }
        return resp;
    }

    private String getMessage(Throwable t) {
        String msg = null;
        if (t instanceof ResponseStatusException) {
            msg = ((ResponseStatusException)t).getReason();
        }
        return msg == null ? t.getMessage() : msg;
    }

    private Integer getErrorCode(Integer errorCode) {
        return errorCode == 999998 ? 900000 : errorCode;
    }

    private ExceptionResolver<Throwable> supportsExceptionType(String beanName, Class<? extends Throwable> exceptionType) {
        DefaultListableBeanFactory beanFactory = null;
        if (this.applicationContext instanceof DefaultListableBeanFactory) {
            beanFactory = (DefaultListableBeanFactory)this.applicationContext;
        } else if (this.applicationContext instanceof GenericApplicationContext) {
            beanFactory = ((GenericApplicationContext)this.applicationContext).getDefaultListableBeanFactory();
        }
        if (beanFactory != null) {
            Class targetClass;
            GenericExceptionResolver genericExceptionResolver;
            ExceptionResolver exceptionResolver = (ExceptionResolver)this.applicationContext.getBean(beanName, ExceptionResolver.class);
            if (exceptionResolver instanceof GenericExceptionResolver && (genericExceptionResolver = (GenericExceptionResolver)exceptionResolver).supportsType(exceptionType)) {
                return exceptionResolver;
            }
            ResolvableType declaredExceptionType = this.resolveDeclaredExceptionType(exceptionResolver.getClass());
            if ((declaredExceptionType == null || declaredExceptionType.isAssignableFrom(Throwable.class)) && (targetClass = AopUtils.getTargetClass((Object)exceptionResolver)) != exceptionResolver.getClass()) {
                declaredExceptionType = this.resolveDeclaredExceptionType(targetClass);
            }
            if (declaredExceptionType == null || declaredExceptionType.isAssignableFrom(exceptionType)) {
                try {
                    BeanDefinition bd = beanFactory.getMergedBeanDefinition(beanName);
                    ResolvableType genericExceptionType = bd.getResolvableType().as(ExceptionResolver.class).getGeneric(new int[0]);
                    if (genericExceptionType == ResolvableType.NONE || genericExceptionType.isAssignableFrom(exceptionType)) {
                        return exceptionResolver;
                    }
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private ResolvableType resolveDeclaredExceptionType(Class<?> exceptionResolverType) {
        ResolvableType exceptionType = exceptionResolverTypeCache.computeIfAbsent(exceptionResolverType, e -> ResolvableType.forClass((Class)exceptionResolverType).as(ExceptionResolver.class).getGeneric(new int[0]));
        return exceptionType != ResolvableType.NONE ? exceptionType : null;
    }

    private List<ValidationErrorBean> dealBindingResult(BindingResult bindingResult) {
        return bindingResult.getAllErrors().stream().map(e -> {
            if (e instanceof FieldError) {
                FieldError fieldError = (FieldError)e;
                return new ValidationErrorBean(e.getDefaultMessage(), fieldError.getField(), fieldError.getRejectedValue() == null ? null : fieldError.getRejectedValue().toString());
            }
            return new ValidationErrorBean(e.getDefaultMessage(), e.getObjectName(), null);
        }).collect(Collectors.toList());
    }

    @Override
    public void handleError(Error error) {
        ExceptionProperties.JvmError jvm;
        if (error instanceof VirtualMachineError && (jvm = this.properties.getJvmError()) != null && jvm.isExit()) {
            System.exit(jvm.getStatus());
        }
    }

    @Override
    public void logError(Throwable t) {
        if (this.properties.isRemoveFrameworkStack()) {
            Throwable[] suppressed;
            this.dealCurrentStackTraceElement(t);
            for (Throwable throwable : suppressed = t.getSuppressed()) {
                this.dealCurrentStackTraceElement(throwable);
            }
        }
        this.log.error("The exception information is as follows", t);
    }

    private void dealCurrentStackTraceElement(Throwable exception) {
        if (Objects.isNull(exception.getCause())) {
            return;
        }
        exception.setStackTrace((StackTraceElement[])Arrays.stream(exception.getStackTrace()).filter(s -> s.getClassName().contains(this.basePackage)).toArray(StackTraceElement[]::new));
    }
}

