/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter;

import cn.hiboot.mcn.autoconfigure.web.exception.ExceptionResolver;
import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessor;
import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessorJacksonConfig;
import cn.hiboot.mcn.autoconfigure.web.filter.special.ParamProcessorAutoConfiguration;
import cn.hiboot.mcn.autoconfigure.web.filter.xss.XssAutoConfiguration;
import cn.hiboot.mcn.core.exception.ServiceException;
import cn.hiboot.mcn.core.model.result.RestResp;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.HttpMessageNotReadableException;

@AutoConfiguration(before={JacksonAutoConfiguration.class}, after={ParamProcessorAutoConfiguration.class, XssAutoConfiguration.class})
@Import(value={NameValueProcessorJacksonConfig.class})
@ConditionalOnBean(value={NameValueProcessor.class})
public class FilterAutoConfiguration {
    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public ExceptionResolver<HttpMessageNotReadableException> specialSymbolExceptionResolver() {
        return t -> {
            ServiceException serviceException = ServiceException.find((Throwable)t);
            if (serviceException == null || serviceException.getCode() != 300009) {
                return null;
            }
            return RestResp.error((Integer)serviceException.getCode(), (String)serviceException.getMessage());
        };
    }
}

