/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.common;

import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessor;
import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessorProperties;
import cn.hiboot.mcn.autoconfigure.web.filter.common.RequestMatcher;
import cn.hiboot.mcn.autoconfigure.web.filter.special.ParamProcessor;
import cn.hiboot.mcn.autoconfigure.web.filter.special.ParamProcessorProperties;
import cn.hiboot.mcn.autoconfigure.web.filter.xss.XssProcessor;
import cn.hiboot.mcn.autoconfigure.web.filter.xss.XssProperties;
import cn.hiboot.mcn.core.util.McnAssert;
import cn.hiboot.mcn.core.util.SpringBeanUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

class DelegateNameValueProcessor
implements NameValueProcessor {
    private final List<ValueProcessor> valueProcessors;

    DelegateNameValueProcessor(ObjectProvider<NameValueProcessor> valueProcessors) {
        this.valueProcessors = valueProcessors.orderedStream().map(v -> {
            McnAssert.state((v instanceof ParamProcessor || v instanceof XssProcessor ? 1 : 0) != 0, (String)"NameValueProcessor must be ParamProcessor or XssProcessor impl");
            NameValueProcessorProperties properties = v instanceof ParamProcessor ? (NameValueProcessorProperties)SpringBeanUtils.getBean(ParamProcessorProperties.class) : (NameValueProcessorProperties)SpringBeanUtils.getBean(XssProperties.class);
            return new ValueProcessor((NameValueProcessor)v, properties);
        }).collect(Collectors.toList());
    }

    @Override
    public String process(String name, String value) {
        for (ValueProcessor valueProcessor : this.valueProcessors) {
            if (!valueProcessor.match(name)) continue;
            value = valueProcessor.process(name, value);
        }
        return value;
    }

    private static class ValueProcessor
    implements NameValueProcessor {
        NameValueProcessor nameValueProcessor;
        RequestMatcher requestMatcher;
        List<String> excludeFields;
        boolean escapeResponse;

        public ValueProcessor(NameValueProcessor nameValueProcessor, NameValueProcessorProperties properties) {
            this.nameValueProcessor = nameValueProcessor;
            this.requestMatcher = new RequestMatcher(properties.getIncludeUrls(), properties.getExcludeUrls()).enableDefaultExclude();
            this.excludeFields = properties.getExcludeFields();
            if (properties instanceof XssProperties) {
                this.escapeResponse = ((XssProperties)properties).isEscapeResponse();
            }
        }

        boolean match(String name) {
            if (this.excludeFields != null && this.excludeFields.contains(name)) {
                return false;
            }
            HttpServletRequest httpServletRequest = this.getHttpRequest();
            if (httpServletRequest == null) {
                return true;
            }
            return this.requestMatcher.matches(httpServletRequest);
        }

        private HttpServletRequest getHttpRequest() {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (requestAttributes == null) {
                return null;
            }
            return requestAttributes.getRequest();
        }

        @Override
        public String process(String name, String value) {
            if (name == null && !this.escapeResponse) {
                return value;
            }
            return this.nameValueProcessor.process(name, value);
        }
    }
}

