/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StreamUtils;

public interface JsonRequestHelper {
    public static String getData(HttpServletRequest request) {
        try {
            return JsonRequestHelper.getData((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getData(InputStream in) {
        try {
            return StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static boolean isJsonRequest(HttpServletRequest request) {
        String header = request.getHeader("Content-Type");
        if (header == null) {
            return false;
        }
        return header.contains("application/json");
    }

    public static ServletInputStream createInputStream(String data) {
        final ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return arrayInputStream.read();
            }
        };
    }
}

