/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.common;

import cn.hiboot.mcn.autoconfigure.web.filter.common.DelegateNameValueProcessor;
import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessor;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class NameValueProcessorJacksonConfig
implements Jackson2ObjectMapperBuilderCustomizer {
    private static final ThreadLocal<Boolean> feignRequest = ThreadLocal.withInitial(() -> false);
    private final DelegateNameValueProcessor delegateValueProcessor;

    public NameValueProcessorJacksonConfig(ObjectProvider<NameValueProcessor> valueProcessors) {
        this.delegateValueProcessor = new DelegateNameValueProcessor(valueProcessors);
    }

    public static void setFeignRequest() {
        feignRequest.set(true);
    }

    public static void removeFeignRequest() {
        feignRequest.remove();
    }

    private String clean(String name, String text) {
        if (feignRequest.get().booleanValue()) {
            return text;
        }
        return this.delegateValueProcessor.process(name, text);
    }

    public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
        jacksonObjectMapperBuilder.serializers(new JsonSerializer[]{new JsonSerializer<String>(){

            public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(NameValueProcessorJacksonConfig.this.clean(null, value));
            }

            public Class<String> handledType() {
                return String.class;
            }
        }});
        jacksonObjectMapperBuilder.deserializers(new JsonDeserializer[]{new JsonDeserializer<String>(){

            public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                return NameValueProcessorJacksonConfig.this.clean(p.currentName(), p.getText());
            }

            public Class<String> handledType() {
                return String.class;
            }
        }});
    }
}

