/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.common;

import cn.hiboot.mcn.autoconfigure.web.security.WebSecurityProperties;
import cn.hiboot.mcn.core.util.McnAssert;
import cn.hiboot.mcn.core.util.SpringBeanUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.AntPathMatcher;

public class RequestMatcher {
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private List<String> includeUrls = Collections.singletonList("/**");
    private List<String> excludeUrls = Collections.emptyList();

    private RequestMatcher() {
    }

    public RequestMatcher(List<String> includeUrls, List<String> excludeUrls) {
        McnAssert.notNull(includeUrls, (String)"includeUrls must be not null");
        McnAssert.notNull(excludeUrls, (String)"includeUrls must be not null");
        this.includeUrls = includeUrls;
        this.excludeUrls = excludeUrls;
    }

    public RequestMatcher enableDefaultExclude() {
        WebSecurityProperties webSecurityProperties = (WebSecurityProperties)SpringBeanUtils.getBean(WebSecurityProperties.class);
        if (webSecurityProperties.isEnableDefaultIgnore()) {
            ArrayList<String> excludePatterns = new ArrayList<String>(this.excludeUrls);
            Collections.addAll(excludePatterns, webSecurityProperties.getDefaultExcludeUrls());
            this.excludeUrls = excludePatterns;
        }
        return this;
    }

    public boolean matches(HttpServletRequest request) {
        String url = request.getServletPath();
        if (this.doMatch(url, this.excludeUrls)) {
            return false;
        }
        return this.doMatch(url, this.includeUrls);
    }

    public boolean matches(ServerHttpRequest request) {
        String url = request.getPath().pathWithinApplication().value();
        if (this.doMatch(url, this.excludeUrls)) {
            return false;
        }
        return this.doMatch(url, this.includeUrls);
    }

    private boolean doMatch(String url, List<String> urls) {
        for (String pattern : urls) {
            if (!this.antPathMatcher.match(pattern, url)) continue;
            return true;
        }
        return false;
    }
}

