/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.common.reactive;

import cn.hiboot.mcn.autoconfigure.web.filter.common.JsonRequestHelper;
import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessor;
import cn.hiboot.mcn.core.util.McnUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

class NameValueProcessorRequestDecorator
extends ServerHttpRequestDecorator {
    private List<String> excludeFields;
    private boolean filterParameterName;
    private boolean processPayload;
    private boolean filterHeaderValue;
    private final NameValueProcessor valueProcessor;

    public NameValueProcessorRequestDecorator(ServerHttpRequest request, NameValueProcessor valueProcessor) {
        super(request);
        this.valueProcessor = valueProcessor;
    }

    public NameValueProcessorRequestDecorator excludeFields(List<String> excludeFields) {
        this.excludeFields = excludeFields;
        return this;
    }

    public NameValueProcessorRequestDecorator filterParameterName(boolean filterParameterName) {
        this.filterParameterName = filterParameterName;
        return this;
    }

    public NameValueProcessorRequestDecorator filterHeaderValue(boolean filterHeaderValue) {
        this.filterHeaderValue = filterHeaderValue;
        return this;
    }

    public NameValueProcessorRequestDecorator processPayload(boolean processPayload) {
        this.processPayload = processPayload;
        return this;
    }

    public MultiValueMap<String, String> getQueryParams() {
        return this.process((MultiValueMap<String, String>)super.getQueryParams());
    }

    MultiValueMap<String, String> process(MultiValueMap<String, String> data) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        if (McnUtils.isNotNullAndEmpty(data)) {
            Iterator iterator = data.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String currentKey = key = (String)iterator.next();
                key = this.cleanParameterName(currentKey);
                List values = (List)data.get((Object)currentKey);
                if (this.isExcludeParameter(currentKey)) {
                    map.put((Object)currentKey, (Object)values);
                    continue;
                }
                ArrayList<String> rs = new ArrayList<String>();
                for (String value : values) {
                    if (McnUtils.isNotNullAndEmpty((Object)value)) {
                        value = this.cleanParameterValue(currentKey, value);
                    }
                    rs.add(value);
                }
                map.put((Object)key, Collections.unmodifiableList(rs));
            }
        }
        return map;
    }

    public HttpHeaders getHeaders() {
        if (this.filterHeaderValue) {
            return new HttpHeaders(this.process((MultiValueMap<String, String>)super.getHeaders()));
        }
        return super.getHeaders();
    }

    public Flux<DataBuffer> getBody() {
        if (this.processPayload) {
            return super.getBody().flatMap(dataBuffer -> {
                String data = JsonRequestHelper.getData(dataBuffer.asInputStream());
                data = this.clean(null, data);
                return Flux.just((Object)dataBuffer.factory().wrap(data.getBytes(StandardCharsets.UTF_8)));
            });
        }
        return super.getBody();
    }

    private boolean isExcludeParameter(String name) {
        if (CollectionUtils.isEmpty(this.excludeFields)) {
            return false;
        }
        return this.excludeFields.contains(name);
    }

    private String cleanParameterName(String name) {
        if (this.filterParameterName) {
            return this.clean(name, name);
        }
        return name;
    }

    private String cleanParameterValue(String name, String value) {
        return this.clean(name, value);
    }

    private String clean(String name, String text) {
        return this.valueProcessor.process(name, text);
    }
}

