/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.common.reactive;

import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessor;
import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessorProperties;
import cn.hiboot.mcn.autoconfigure.web.filter.common.RequestMatcher;
import cn.hiboot.mcn.autoconfigure.web.filter.common.reactive.NameValueProcessorRequestDecorator;
import org.springframework.boot.web.reactive.filter.OrderedWebFilter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ReactiveNameValueProcessorFilter
implements OrderedWebFilter {
    private final NameValueProcessorProperties properties;
    private final NameValueProcessor valueProcessor;
    private final RequestMatcher requestMatcher;

    public ReactiveNameValueProcessorFilter(NameValueProcessorProperties properties, NameValueProcessor valueProcessor) {
        this.properties = properties;
        this.valueProcessor = valueProcessor;
        this.requestMatcher = new RequestMatcher(properties.getIncludeUrls(), properties.getExcludeUrls()).enableDefaultExclude();
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.requestMatcher.matches(exchange.getRequest())) {
            NameValueProcessorRequestDecorator decorator = new NameValueProcessorRequestDecorator(exchange.getRequest(), this.valueProcessor).filterHeaderValue(this.properties.isFilterHeaderValue()).filterParameterName(this.properties.isFilterParameterName()).processPayload(this.properties.isProcessPayload()).excludeFields(this.properties.getExcludeFields());
            return exchange.getFormData().flatMap(formData -> Mono.just(decorator.process((MultiValueMap<String, String>)formData))).flatMap(p -> chain.filter(exchange.mutate().request((ServerHttpRequest)decorator).build()));
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return this.properties.getOrder();
    }
}

