/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.common.servlet;

import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessor;
import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessorProperties;
import cn.hiboot.mcn.autoconfigure.web.filter.common.RequestMatcher;
import cn.hiboot.mcn.autoconfigure.web.filter.common.servlet.NameValueProcessorRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class NameValueProcessorFilter
implements Filter {
    private final NameValueProcessorProperties properties;
    private final NameValueProcessor valueProcessor;
    private final RequestMatcher requestMatcher;

    public NameValueProcessorFilter(NameValueProcessorProperties properties, NameValueProcessor valueProcessor) {
        this.properties = properties;
        this.valueProcessor = valueProcessor;
        this.requestMatcher = new RequestMatcher(properties.getIncludeUrls(), properties.getExcludeUrls()).enableDefaultExclude();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (this.requestMatcher.matches(req)) {
            request = new NameValueProcessorRequestWrapper(req, this.valueProcessor).filterHeaderValue(this.properties.isFilterHeaderValue()).filterParameterName(this.properties.isFilterParameterName()).processPayload(this.properties.isProcessPayload()).excludeFields(this.properties.getExcludeFields());
        }
        filterChain.doFilter(request, response);
    }
}

