/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.common.servlet;

import cn.hiboot.mcn.autoconfigure.web.filter.common.JsonRequestHelper;
import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessor;
import cn.hiboot.mcn.core.util.McnUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.CollectionUtils;

class NameValueProcessorRequestWrapper
extends HttpServletRequestWrapper {
    private List<String> excludeFields;
    private boolean filterParameterName;
    private boolean processPayload;
    private boolean filterHeaderValue;
    private final NameValueProcessor valueProcessor;

    public NameValueProcessorRequestWrapper(HttpServletRequest request, NameValueProcessor valueProcessor) {
        super(request);
        this.valueProcessor = valueProcessor;
    }

    public NameValueProcessorRequestWrapper excludeFields(List<String> excludeFields) {
        this.excludeFields = excludeFields;
        return this;
    }

    public NameValueProcessorRequestWrapper filterParameterName(boolean filterParameterName) {
        this.filterParameterName = filterParameterName;
        return this;
    }

    public NameValueProcessorRequestWrapper filterHeaderValue(boolean filterHeaderValue) {
        this.filterHeaderValue = filterHeaderValue;
        return this;
    }

    public NameValueProcessorRequestWrapper processPayload(boolean processPayload) {
        this.processPayload = processPayload;
        return this;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.processPayload) {
            String data = JsonRequestHelper.getData((HttpServletRequest)this.getRequest());
            data = this.clean(null, data);
            return JsonRequestHelper.createInputStream(data);
        }
        return super.getInputStream();
    }

    public String getParameter(String name) {
        if (this.isExcludeParameter(name)) {
            return super.getParameter(name);
        }
        String value = super.getParameter(this.cleanParameterName(name));
        if (McnUtils.isNotNullAndEmpty((Object)value)) {
            value = this.cleanParameterValue(name, value);
        }
        return value;
    }

    private boolean isExcludeParameter(String name) {
        if (CollectionUtils.isEmpty(this.excludeFields)) {
            return false;
        }
        return this.excludeFields.contains(name);
    }

    public String[] getParameterValues(String name) {
        if (this.isExcludeParameter(name)) {
            return super.getParameterValues(name);
        }
        String[] arr = super.getParameterValues(this.cleanParameterName(name));
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.cleanParameterValue(name, arr[i]);
            }
        }
        return arr;
    }

    public Map<String, String[]> getParameterMap() {
        Map parameters = super.getParameterMap();
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        if (parameters != null) {
            Iterator iterator = parameters.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String currentKey = key = (String)iterator.next();
                key = this.cleanParameterName(currentKey);
                String[] values = (String[])parameters.get(currentKey);
                if (this.isExcludeParameter(currentKey)) {
                    map.put(currentKey, values);
                    continue;
                }
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    if (McnUtils.isNotNullAndEmpty((Object)value)) {
                        value = this.cleanParameterValue(currentKey, value);
                    }
                    values[i] = value;
                }
                map.put(key, values);
            }
        }
        return map;
    }

    public String getHeader(String name) {
        String value = super.getHeader(this.cleanParameterName(name));
        if (this.filterHeaderValue && McnUtils.isNotNullAndEmpty((Object)value)) {
            value = this.cleanParameterValue(name, value);
        }
        return value;
    }

    private String cleanParameterName(String name) {
        if (this.filterParameterName) {
            return this.clean(name, name);
        }
        return name;
    }

    private String cleanParameterValue(String name, String value) {
        return this.clean(name, value);
    }

    private String clean(String name, String text) {
        return this.valueProcessor.process(name, text);
    }
}

