/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.cors;

import cn.hiboot.mcn.autoconfigure.web.filter.cors.CorsProperties;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={CorsProperties.class})
@ConditionalOnProperty(prefix="filter", name={"cross"}, havingValue="true")
public class CorsFilterAutoConfiguration {
    private final CorsProperties corsProperties;

    public CorsFilterAutoConfiguration(CorsProperties corsProperties) {
        this.corsProperties = corsProperties;
    }

    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilterRegistration(CorsConfigurationSource corsConfigurationSource) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new CorsFilter(corsConfigurationSource), new ServletRegistrationBean[0]);
        filterRegistrationBean.setOrder(this.corsProperties.getOrder());
        filterRegistrationBean.setName(this.corsProperties.getName());
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnMissingBean(name={"corsConfigurationSource"})
    public CorsConfigurationSource corsConfigurationSource() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowCredentials(this.corsProperties.getAllowCredentials());
        corsConfiguration.addAllowedOrigin(this.corsProperties.getAllowedOrigin());
        corsConfiguration.addAllowedHeader(this.corsProperties.getAllowedHeader());
        corsConfiguration.addAllowedMethod(this.corsProperties.getAllowedMethod());
        corsConfiguration.setMaxAge(this.corsProperties.getMaxAge());
        corsConfiguration.setExposedHeaders(this.corsProperties.getExposedHeaders());
        source.registerCorsConfiguration(this.corsProperties.getPattern(), corsConfiguration);
        return source;
    }
}

