/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.integrity;

import cn.hiboot.mcn.autoconfigure.web.filter.integrity.DataIntegrityFilter;
import cn.hiboot.mcn.autoconfigure.web.filter.integrity.DataIntegrityProperties;
import cn.hiboot.mcn.autoconfigure.web.filter.integrity.reactive.ReactiveDataIntegrityFilter;
import cn.hiboot.mcn.autoconfigure.web.security.WebSecurityProperties;
import cn.hutool.crypto.SmUtil;
import javax.servlet.Filter;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.server.WebFilter;

@AutoConfiguration
@ConditionalOnClass(value={SmUtil.class, SM3Digest.class})
@EnableConfigurationProperties(value={DataIntegrityProperties.class, WebSecurityProperties.class})
@ConditionalOnProperty(prefix="data.integrity", name={"enable"}, havingValue="true")
public class DataIntegrityAutoConfiguration {

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnClass(value={WebFilter.class})
    static class ReactiveDataIntegrityFilterConfig {
        ReactiveDataIntegrityFilterConfig() {
        }

        @Bean
        ReactiveDataIntegrityFilter dataIntegrityFilter(DataIntegrityProperties dataIntegrityProperties) {
            return new ReactiveDataIntegrityFilter(dataIntegrityProperties);
        }
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={Filter.class})
    static class ServletDataIntegrityFilterConfig {
        ServletDataIntegrityFilterConfig() {
        }

        @Bean
        DataIntegrityFilter dataIntegrityFilter(DataIntegrityProperties dataIntegrityProperties) {
            return new DataIntegrityFilter(dataIntegrityProperties);
        }
    }
}

