/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.integrity;

import cn.hiboot.mcn.autoconfigure.web.filter.common.JsonRequestHelper;
import cn.hiboot.mcn.autoconfigure.web.filter.common.RequestMatcher;
import cn.hiboot.mcn.autoconfigure.web.filter.common.servlet.RequestPayloadRequestWrapper;
import cn.hiboot.mcn.autoconfigure.web.filter.integrity.DataIntegrityProperties;
import cn.hiboot.mcn.autoconfigure.web.filter.integrity.DataIntegrityUtils;
import cn.hiboot.mcn.autoconfigure.web.mvc.ResponseUtils;
import cn.hiboot.mcn.core.util.McnUtils;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public class DataIntegrityFilter
implements Filter,
Ordered {
    private final Logger log = LoggerFactory.getLogger(DataIntegrityFilter.class);
    private final DataIntegrityProperties dataIntegrityProperties;
    private final RequestMatcher requestMatcher;

    public DataIntegrityFilter(DataIntegrityProperties dataIntegrityProperties) {
        this.dataIntegrityProperties = dataIntegrityProperties;
        this.requestMatcher = new RequestMatcher(dataIntegrityProperties.getIncludePatterns(), dataIntegrityProperties.getExcludePatterns()).enableDefaultExclude();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (this.requestMatcher.matches(request)) {
            RequestPayloadRequestWrapper wrapper;
            String timestamp = request.getHeader("TSM");
            if (timestamp == null) {
                timestamp = request.getHeader("timestamp");
            }
            String nonceStr = request.getHeader("nonceStr");
            String signature = request.getHeader("signature");
            if (StrUtil.isEmpty((CharSequence)timestamp)) {
                ResponseUtils.failed("\u9a8c\u8bc1\u5931\u8d25,\u65e0\u6548\u7684\u65f6\u95f4\u6233", (HttpServletResponse)servletResponse);
                return;
            }
            if (this.dataIntegrityProperties.isCheckReplay()) {
                long receiveTime = Long.parseLong(timestamp);
                long NONCE_STR_TIMEOUT_SECONDS = this.dataIntegrityProperties.getTimeout().toMillis();
                if (System.currentTimeMillis() - receiveTime > NONCE_STR_TIMEOUT_SECONDS) {
                    ResponseUtils.failed("\u9a8c\u8bc1\u5931\u8d25,\u65f6\u95f4\u6233\u8fc7\u671f", (HttpServletResponse)servletResponse);
                    return;
                }
            }
            String payload = null;
            if (JsonRequestHelper.isJsonRequest(request) && !(payload = (wrapper = new RequestPayloadRequestWrapper(request)).getPayload()).isEmpty()) {
                servletRequest = wrapper;
            }
            if (this.isInValid(signature, timestamp, nonceStr, request, payload)) {
                ResponseUtils.failed("\u9a8c\u8bc1\u5931\u8d25,\u6570\u636e\u88ab\u7be1\u6539", (HttpServletResponse)servletResponse);
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean isInValid(String signature, String timestamp, String nonceStr, HttpServletRequest request, String payload) {
        String sign;
        boolean rs;
        if (StrUtil.isEmpty((CharSequence)signature)) {
            return true;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] parameterValues = request.getParameterValues(name);
            params.put(name, parameterValues[parameterValues.length - 1]);
        }
        String fileInfo = null;
        if (request.getContentType() != null && request.getContentType().contains("multipart/form-data") && this.dataIntegrityProperties.isCheckUpload()) {
            fileInfo = this.parseUpload(request);
        }
        if (rs = Objects.equals(signature, sign = DataIntegrityUtils.signature(timestamp, nonceStr, params, fileInfo, payload))) {
            return false;
        }
        this.log.error("kv param = {},payload = {},fileInfo = {},signature = {}", new Object[]{params, payload, fileInfo, sign});
        return true;
    }

    public int getOrder() {
        return this.dataIntegrityProperties.getOrder();
    }

    private String parseUpload(HttpServletRequest request) {
        StringBuilder str = new StringBuilder();
        try {
            Collection parts = request.getParts();
            for (Part part : parts) {
                str.append(DataIntegrityUtils.md5UploadFile(McnUtils.copyToByteArray((InputStream)part.getInputStream()), part.getSubmittedFileName())).append("&");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (str.length() != 0) {
            return str.substring(0, str.length() - 1);
        }
        return str.toString();
    }
}

