/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.integrity;

import cn.hiboot.mcn.core.tuples.Triplet;
import cn.hiboot.mcn.core.util.JacksonUtils;
import cn.hiboot.mcn.core.util.McnUtils;
import cn.hutool.core.net.URLDecoder;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.digest.DigestUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.util.StringUtils;

public abstract class DataIntegrityUtils {
    public static Triplet<String, String, String> signature(Map<String, Object> params, String payload) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String nonceStr = McnUtils.simpleUUID().substring(0, 8);
        String signature = DataIntegrityUtils.signature(timestamp, nonceStr, params, null, payload);
        return Triplet.with((Object)timestamp, (Object)nonceStr, (Object)signature);
    }

    public static String signature(String timestamp, String nonceStr, Map<String, Object> params, String fileInfo, String payload) {
        String param = DataIntegrityUtils.sortQueryParamString(params);
        if (fileInfo != null) {
            param = param + fileInfo;
        }
        if (StringUtils.hasText((String)payload)) {
            param = param + payload;
        }
        String qs = StrUtil.isNotEmpty((CharSequence)param) ? String.format("%s&timestamp=%s&nonceStr=%s", param, timestamp, nonceStr) : String.format("timestamp=%s&nonceStr=%s", timestamp, nonceStr);
        return SmUtil.sm3((String)qs);
    }

    private static String sortQueryParamString(Map<String, Object> params) {
        ArrayList<String> listKeys = new ArrayList<String>(params.keySet());
        Collections.sort(listKeys);
        StrBuilder content = StrBuilder.create();
        for (String param : listKeys) {
            if (param.equals("signature")) continue;
            Object obj = params.get(param);
            if (obj instanceof Collection || obj instanceof Map) {
                obj = JacksonUtils.toJson((Object)obj);
            }
            content.append((CharSequence)param).append((CharSequence)"=").append(obj).append((CharSequence)"&");
        }
        if (!content.isEmpty()) {
            return content.subString(0, content.length() - 1);
        }
        return content.toString();
    }

    public static String md5UploadFile(byte[] bytes, String filename) {
        if (filename != null && filename.startsWith("=?") && filename.endsWith("?=")) {
            filename = URLDecoder.decode((String)filename, (Charset)StandardCharsets.UTF_8);
        }
        String md5 = DigestUtil.md5Hex((byte[])bytes);
        return filename + "=" + md5;
    }
}

