/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.integrity.reactive;

import cn.hiboot.mcn.autoconfigure.web.filter.common.JsonRequestHelper;
import cn.hiboot.mcn.autoconfigure.web.filter.common.RequestMatcher;
import cn.hiboot.mcn.autoconfigure.web.filter.integrity.DataIntegrityException;
import cn.hiboot.mcn.autoconfigure.web.filter.integrity.DataIntegrityProperties;
import cn.hiboot.mcn.autoconfigure.web.filter.integrity.DataIntegrityUtils;
import cn.hiboot.mcn.autoconfigure.web.reactor.ServerHttpResponseUtils;
import cn.hiboot.mcn.core.tuples.Pair;
import cn.hutool.core.util.StrUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.filter.OrderedWebFilter;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveDataIntegrityFilter
implements OrderedWebFilter {
    private final Logger log = LoggerFactory.getLogger(ReactiveDataIntegrityFilter.class);
    private final DataIntegrityProperties dataIntegrityProperties;
    private final RequestMatcher requestMatcher;

    public ReactiveDataIntegrityFilter(DataIntegrityProperties dataIntegrityProperties) {
        this.dataIntegrityProperties = dataIntegrityProperties;
        this.requestMatcher = new RequestMatcher(dataIntegrityProperties.getIncludePatterns(), dataIntegrityProperties.getExcludePatterns()).enableDefaultExclude();
    }

    private String getHeader(ServerHttpRequest request, String headerName) {
        return request.getHeaders().getFirst(headerName);
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return Mono.just((Object)exchange.getRequest()).filter(this.requestMatcher::matches).flatMap(request -> {
            String signature;
            String timestamp;
            String tsm = this.getHeader((ServerHttpRequest)request, "TSM");
            if (tsm == null) {
                tsm = this.getHeader((ServerHttpRequest)request, "timestamp");
            }
            if (StrUtil.isEmpty((CharSequence)(timestamp = tsm))) {
                return Mono.error((Throwable)((Object)DataIntegrityException.newInstance("\u9a8c\u8bc1\u5931\u8d25,\u65e0\u6548\u7684\u65f6\u95f4\u6233")));
            }
            if (this.dataIntegrityProperties.isCheckReplay()) {
                long receiveTime = Long.parseLong(timestamp);
                long NONCE_STR_TIMEOUT_SECONDS = this.dataIntegrityProperties.getTimeout().toMillis();
                if (System.currentTimeMillis() - receiveTime > NONCE_STR_TIMEOUT_SECONDS) {
                    return Mono.error((Throwable)((Object)DataIntegrityException.newInstance("\u9a8c\u8bc1\u5931\u8d25,\u65e0\u6548\u7684\u65f6\u95f4\u6233")));
                }
            }
            if (StrUtil.isEmpty((CharSequence)(signature = this.getHeader((ServerHttpRequest)request, "signature")))) {
                return Mono.error((Throwable)((Object)DataIntegrityException.newInstance("\u9a8c\u8bc1\u5931\u8d25,\u6570\u636e\u88ab\u7be1\u6539")));
            }
            final String nonceStr = this.getHeader((ServerHttpRequest)request, "nonceStr");
            return exchange.getFormData().map(formParams -> {
                HashMap params = new HashMap();
                exchange.getRequest().getQueryParams().forEach((name, value) -> params.put(name, value.get(0)));
                formParams.forEach((name, value) -> params.put(name, value.get(0)));
                return params;
            }).flatMap(params -> this.parseUpload(exchange).map(fileInfo -> Pair.with((Object)params, (Object)fileInfo))).flatMap(p -> {
                if (request.getMethod() == HttpMethod.POST && MediaType.APPLICATION_JSON.isCompatibleWith(request.getHeaders().getContentType())) {
                    ServerHttpRequestDecorator decorator = new ServerHttpRequestDecorator((ServerHttpRequest)request, (Pair)p){
                        final /* synthetic */ Pair val$p;
                        {
                            this.val$p = pair;
                            super(x0);
                        }

                        public Flux<DataBuffer> getBody() {
                            return super.getBody().flatMap(dataBuffer -> {
                                int length = dataBuffer.readableByteCount();
                                String payload = JsonRequestHelper.getData(dataBuffer.asInputStream());
                                if (ReactiveDataIntegrityFilter.this.isInValid(signature, timestamp, nonceStr, (Map)this.val$p.getValue0(), null, payload)) {
                                    return Mono.error((Throwable)((Object)DataIntegrityException.newInstance("\u9a8c\u8bc1\u5931\u8d25,\u6570\u636e\u88ab\u7be1\u6539")));
                                }
                                return Flux.just((Object)dataBuffer.retainedSlice(0, length));
                            });
                        }
                    };
                    return Mono.just((Object)exchange.mutate().request((ServerHttpRequest)decorator).build());
                }
                if (this.isInValid(signature, timestamp, nonceStr, (Map)p.getValue0(), (String)p.getValue1(), null)) {
                    return Mono.error((Throwable)((Object)DataIntegrityException.newInstance("\u9a8c\u8bc1\u5931\u8d25,\u6570\u636e\u88ab\u7be1\u6539")));
                }
                return Mono.just((Object)exchange);
            });
        }).flatMap(arg_0 -> ((WebFilterChain)chain).filter(arg_0)).onErrorResume(DataIntegrityException.class, ex -> {
            this.log.error("Check DataIntegrity Failed: {}", (Object)ex.getMessage());
            return ServerHttpResponseUtils.failed(ex.getMessage(), exchange.getResponse());
        });
    }

    private boolean isInValid(String signature, String timestamp, String nonceStr, Map<String, Object> params, String fileInfo, String payload) {
        String sign = DataIntegrityUtils.signature(timestamp, nonceStr, params, fileInfo, payload);
        if (Objects.equals(signature, sign)) {
            return false;
        }
        this.log.error("kv param = {},payload = {},fileInfo = {},signature = {}", new Object[]{params, payload, fileInfo, sign});
        return true;
    }

    private Mono<String> parseUpload(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(request.getHeaders().getContentType()) && this.dataIntegrityProperties.isCheckUpload()) {
            return exchange.getMultipartData().map(m -> {
                StringBuilder str = new StringBuilder();
                m.forEach((k, v) -> {
                    for (Part part : v) {
                        part.content().map(dataBuffer -> dataBuffer.asByteBuffer().array()).subscribe(bytes -> str.append(DataIntegrityUtils.md5UploadFile(bytes, this.getSubmittedFileName(part))).append("&"));
                    }
                });
                if (str.length() != 0) {
                    return str.substring(0, str.length() - 1);
                }
                return str.toString();
            });
        }
        return Mono.just((Object)"");
    }

    public String getSubmittedFileName(Part part) {
        String cdl;
        String fileName = null;
        String cd = part.headers().getFirst("Content-Disposition");
        if (cd != null && ((cdl = cd.toLowerCase(Locale.ENGLISH)).startsWith("form-data") || cdl.startsWith("attachment"))) {
            String[] split;
            for (String s : split = cdl.split(";")) {
                if (!(s = s.trim()).startsWith("filename")) continue;
                fileName = s.split("=")[1].replace("\"", "");
            }
        }
        return fileName;
    }

    public int getOrder() {
        return this.dataIntegrityProperties.getOrder();
    }
}

