/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.special.servlet;

import cn.hiboot.mcn.autoconfigure.web.filter.common.servlet.NameValueProcessorFilter;
import cn.hiboot.mcn.autoconfigure.web.filter.special.CheckParam;
import cn.hiboot.mcn.autoconfigure.web.filter.special.ParamProcessor;
import cn.hiboot.mcn.autoconfigure.web.filter.special.ParamProcessorAutoConfiguration;
import cn.hiboot.mcn.autoconfigure.web.filter.special.ParamProcessorProperties;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.ServletModelAttributeMethodProcessor;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ServletParamProcessorConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="param.processor", name={"use-filter"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<NameValueProcessorFilter> paramProcessorFilterRegistration(ParamProcessor paramProcessor, ParamProcessorProperties properties) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new NameValueProcessorFilter(properties, paramProcessor), new ServletRegistrationBean[0]);
        filterRegistrationBean.setOrder(properties.getOrder());
        filterRegistrationBean.setName(properties.getName());
        return filterRegistrationBean;
    }

    @Bean
    public WebMvcConfigurer webMvcConfig(final ParamProcessor paramProcessor) {
        return new WebMvcConfigurer(){

            public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
                resolvers.add(new KeyValueArgumentResolver(paramProcessor));
                resolvers.add(new HandlerMethodArgumentResolver(){
                    private final ServletModelAttributeMethodProcessor processor = new ServletModelAttributeMethodProcessor(true);

                    public boolean supportsParameter(MethodParameter parameter) {
                        return this.processor.supportsParameter(parameter) && (parameter.hasParameterAnnotation(CheckParam.class) || parameter.getParameterType().getAnnotation(CheckParam.class) != null);
                    }

                    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
                        Object returnValue = this.processor.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
                        if (returnValue == null) {
                            return null;
                        }
                        return ParamProcessorAutoConfiguration.validStringValue(parameter, returnValue, paramProcessor);
                    }
                });
            }
        };
    }

    protected static class KeyValueArgumentResolver
    implements HandlerMethodArgumentResolver {
        private final ParamProcessor paramProcessor;

        public KeyValueArgumentResolver(ParamProcessor paramProcessor) {
            this.paramProcessor = paramProcessor;
        }

        public boolean supportsParameter(MethodParameter parameter) {
            return parameter.hasParameterAnnotation(CheckParam.class) && parameter.getParameterType() == String.class;
        }

        public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
            HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            if (request == null) {
                return null;
            }
            String name = parameter.getParameterName();
            String rule = ((CheckParam)parameter.getParameterAnnotation(CheckParam.class)).value();
            return this.paramProcessor.process(rule, name, request.getParameter(name));
        }
    }
}

