/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.filter.xss;

import cn.hiboot.mcn.autoconfigure.web.filter.common.reactive.ReactiveNameValueProcessorFilter;
import cn.hiboot.mcn.autoconfigure.web.filter.common.servlet.NameValueProcessorFilter;
import cn.hiboot.mcn.autoconfigure.web.filter.xss.XssProcessor;
import cn.hiboot.mcn.autoconfigure.web.filter.xss.XssProperties;
import cn.hiboot.mcn.autoconfigure.web.security.WebSecurityProperties;
import cn.hiboot.mcn.core.exception.ServiceException;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.HtmlUtils;

@AutoConfiguration
@ConditionalOnProperty(prefix="mcn.xss", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={XssProperties.class, WebSecurityProperties.class})
public class XssAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public XssProcessor defaultXssProcessor(XssProperties xssProperties) {
        return (name, value) -> {
            String rs = HtmlUtils.htmlEscape((String)value);
            if (value.equals(rs)) {
                return rs;
            }
            if (xssProperties.isFailedFast()) {
                throw ServiceException.newInstance((Integer)300009);
            }
            return rs;
        };
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Configuration(proxyBeanMethods=false)
    static class ReactiveXssConfiguration {
        ReactiveXssConfiguration() {
        }

        @Bean
        public ReactiveNameValueProcessorFilter xssFilterRegistration(XssProcessor xssProcessor, XssProperties xssProperties) {
            return new ReactiveNameValueProcessorFilter(xssProperties, xssProcessor);
        }
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Configuration(proxyBeanMethods=false)
    static class ServletXssConfiguration {
        ServletXssConfiguration() {
        }

        @Bean
        public FilterRegistrationBean<NameValueProcessorFilter> xssFilterRegistration(XssProcessor xssProcessor, XssProperties xssProperties) {
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new NameValueProcessorFilter(xssProperties, xssProcessor), new ServletRegistrationBean[0]);
            filterRegistrationBean.setOrder(xssProperties.getOrder());
            filterRegistrationBean.setName(xssProperties.getName());
            return filterRegistrationBean;
        }
    }
}

