/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.mvc;

import cn.hiboot.mcn.autoconfigure.web.mvc.Timing;
import cn.hiboot.mcn.core.model.HttpTime;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;

public class DurationAop {
    @Bean
    @Role(value=2)
    Advisor timeAdvisor() {
        return new TimeRecordAdvisor();
    }

    private static class TimeRecordAdvisor
    extends AbstractPointcutAdvisor {
        private final Pointcut pointcut;

        public TimeRecordAdvisor() {
            AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(Timing.class, true);
            ComposablePointcut result = new ComposablePointcut((Pointcut)cpc);
            AnnotationMatchingPointcut mpc = new AnnotationMatchingPointcut(null, Timing.class, true);
            this.pointcut = result.union((Pointcut)mpc);
        }

        public Pointcut getPointcut() {
            return this.pointcut;
        }

        public Advice getAdvice() {
            return invocation -> {
                long start = System.currentTimeMillis();
                Object o = invocation.proceed();
                long duration = System.currentTimeMillis() - start;
                if (o instanceof HttpTime) {
                    HttpTime r = (HttpTime)o;
                    r.setDuration(Long.valueOf(duration));
                }
                return o;
            };
        }
    }
}

