/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.mvc;

import cn.hiboot.mcn.autoconfigure.web.exception.HttpStatusCodeResolver;
import cn.hiboot.mcn.autoconfigure.web.exception.error.GlobalExceptionViewResolver;
import cn.hiboot.mcn.autoconfigure.web.exception.handler.ExceptionHandler;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.Ordered;
import org.springframework.web.HttpMediaTypeException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.util.NestedServletException;

@RestControllerAdvice
public class GlobalExceptionHandler
implements HttpStatusCodeResolver,
Ordered {
    private final GlobalExceptionViewResolver viewResolver;
    private final ExceptionHandler exceptionHandler;

    public GlobalExceptionHandler(ExceptionHandler exceptionHandler, ObjectProvider<GlobalExceptionViewResolver> globalExceptionViewResolvers) {
        this.exceptionHandler = exceptionHandler;
        this.viewResolver = (GlobalExceptionViewResolver)globalExceptionViewResolvers.getIfUnique();
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={Throwable.class})
    public Object handleException(HttpServletRequest request, Throwable exception) {
        if (Objects.nonNull(this.viewResolver) && this.viewResolver.support(request)) {
            this.exceptionHandler.logError(exception);
            return this.viewResolver.view(request, exception);
        }
        return this.exceptionHandler.handleException(exception);
    }

    @Override
    public Integer resolve(Throwable ex) {
        if (ex instanceof ServletRequestBindingException) {
            return 300001;
        }
        if (ex instanceof ServletException) {
            if (ex instanceof NestedServletException && ex.getCause() instanceof Error) {
                this.exceptionHandler.handleError((Error)ex.getCause());
                return 900000;
            }
            int code = 800500;
            if (ex instanceof NoHandlerFoundException) {
                code = 800404;
            } else if (ex instanceof HttpRequestMethodNotSupportedException) {
                code = 800405;
            } else if (ex instanceof HttpMediaTypeException) {
                code = 800406;
            } else if (ex instanceof UnavailableException) {
                code = 800503;
            }
            return code;
        }
        return null;
    }

    public int getOrder() {
        return this.exceptionHandler.config().getOrder();
    }
}

