/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.mvc;

import cn.hiboot.mcn.core.model.result.RestResp;
import cn.hiboot.mcn.core.util.JacksonUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;

public class ResponseUtils {
    public static <T> void success(T data, HttpServletResponse response) {
        ResponseUtils.write(new RestResp(data), response);
    }

    public static <T> void success(T data, Long count, HttpServletResponse response) {
        ResponseUtils.write(new RestResp(data, count.longValue()), response);
    }

    public static void failed(String msg, HttpServletResponse response) {
        ResponseUtils.write(RestResp.error((String)msg), response);
    }

    public static void failed(Integer code, HttpServletResponse response) {
        ResponseUtils.write(RestResp.error((Integer)code), response);
    }

    public static void failed(Integer code, String msg, HttpServletResponse response) {
        ResponseUtils.write(RestResp.error((Integer)code, (String)msg), response);
    }

    public static <T> void write(RestResp<T> resp, HttpServletResponse response) {
        ResponseUtils.write(JacksonUtils.toJson(resp), response);
    }

    public static void write(String str, HttpServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setStatus(200);
        try (PrintWriter out = response.getWriter();){
            out.write(str);
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

