/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.mvc;

import cn.hiboot.mcn.autoconfigure.minio.MinioException;
import cn.hiboot.mcn.autoconfigure.web.exception.ExceptionResolver;
import cn.hiboot.mcn.autoconfigure.web.exception.error.DefaultErrorView;
import cn.hiboot.mcn.autoconfigure.web.exception.error.ErrorPageController;
import cn.hiboot.mcn.autoconfigure.web.mvc.DurationAop;
import cn.hiboot.mcn.autoconfigure.web.mvc.GlobalExceptionHandler;
import cn.hiboot.mcn.autoconfigure.web.mvc.resolver.StrToObj;
import cn.hiboot.mcn.autoconfigure.web.mvc.resolver.StringObjectMethodArgumentResolver;
import cn.hiboot.mcn.core.model.result.RestResp;
import cn.hiboot.mcn.core.util.JacksonUtils;
import io.minio.MinioClient;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@AutoConfiguration(before={ErrorMvcAutoConfiguration.class})
@ConditionalOnClass(value={DispatcherServlet.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Import(value={DurationAop.class})
public class SpringMvcAutoConfiguration {

    @ControllerAdvice
    @Configuration(proxyBeanMethods=false)
    private static class RestRespDataResponseBodyAdvice
    implements ResponseBodyAdvice<RestResp> {
        private RestRespDataResponseBodyAdvice() {
        }

        public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
            return returnType.getParameterType() == RestResp.class && returnType.hasMethodAnnotation(StrToObj.class);
        }

        public RestResp beforeBodyWrite(RestResp body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
            if (body != null && body.getData() instanceof String) {
                body.setData(JacksonUtils.fromJson((Object)body.getData().toString(), ((StrToObj)returnType.getMethodAnnotation(StrToObj.class)).value()));
            }
            return body;
        }
    }

    @Configuration(proxyBeanMethods=false)
    private static class WebMvcConfig
    implements WebMvcConfigurer {
        private WebMvcConfig() {
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
            resolvers.add(new StringObjectMethodArgumentResolver());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MinioClient.class})
    private static class MinioExceptionResolverConfig {
        private MinioExceptionResolverConfig() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"minioExceptionResolver"})
        ExceptionResolver<MinioException> minioExceptionResolver() {
            return t -> RestResp.error((Integer)300010, (String)t.getCause().getMessage());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={GlobalExceptionHandler.class})
    @EnableConfigurationProperties(value={ServerProperties.class})
    protected static class SpringMvcExceptionHandler {
        protected SpringMvcExceptionHandler() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ErrorController.class})
        public ErrorPageController errorController(ErrorAttributes errorAttributes, ServerProperties serverProperties, ObjectProvider<ErrorViewResolver> errorViewResolvers) {
            return new ErrorPageController(errorAttributes, serverProperties.getError(), errorViewResolvers.orderedStream().collect(Collectors.toList()));
        }

        @Bean(name={"error"})
        @ConditionalOnProperty(prefix="server.error.whitelabel", name={"enabled"}, matchIfMissing=true)
        @ConditionalOnMissingBean(name={"error"})
        public View defaultErrorView(ServerProperties serverProperties) {
            return new DefaultErrorView(serverProperties);
        }

        @Bean
        @ConditionalOnMissingBean(value={ErrorAttributes.class}, search=SearchStrategy.CURRENT)
        public DefaultErrorAttributes errorAttributes() {
            return new DefaultErrorAttributes();
        }
    }
}

