/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.reactor;

import cn.hiboot.mcn.autoconfigure.config.ConfigProperties;
import cn.hiboot.mcn.autoconfigure.web.exception.HttpStatusCodeResolver;
import cn.hiboot.mcn.autoconfigure.web.exception.handler.DefaultExceptionHandler;
import cn.hiboot.mcn.autoconfigure.web.exception.handler.ExceptionHandler;
import cn.hiboot.mcn.core.exception.ExceptionKeys;
import cn.hiboot.mcn.core.model.result.RestResp;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

@ConditionalOnMissingBean(value={ErrorWebExceptionHandler.class}, search=SearchStrategy.CURRENT)
public class GlobalErrorExceptionHandler
extends DefaultErrorWebExceptionHandler
implements HttpStatusCodeResolver,
EnvironmentAware,
Ordered {
    private WebFluxProperties webFluxProperties;
    private int order;
    private ExceptionHandler exceptionHandler;

    public GlobalErrorExceptionHandler(ErrorAttributes errorAttributes, WebProperties webProperties, ServerProperties serverProperties, ApplicationContext applicationContext) {
        super(errorAttributes, webProperties.getResources(), serverProperties.getError(), applicationContext);
    }

    @Autowired
    public void configGlobalErrorExceptionHandler(ServerCodecConfigurer serverCodecConfigurer, WebFluxProperties webFluxProperties, DefaultExceptionHandler exceptionHandler) {
        this.setMessageWriters(serverCodecConfigurer.getWriters());
        this.setMessageReaders(serverCodecConfigurer.getReaders());
        this.webFluxProperties = webFluxProperties;
        this.exceptionHandler = exceptionHandler;
    }

    protected Mono<ServerResponse> renderDefaultErrorView(ServerResponse.BodyBuilder responseBody, Map<String, Object> error) {
        return responseBody.bodyValue((Object)ConfigProperties.errorView(error, this.webFluxProperties.getBasePath()));
    }

    protected Mono<ServerResponse> renderErrorResponse(ServerRequest request) {
        return ServerResponse.status((int)HttpStatus.OK.value()).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue(this.handleException(this.getError(request))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestResp<Throwable> handleException(Throwable ex) {
        RestResp resp;
        try {
            resp = this.exceptionHandler.handleException(ex);
        }
        catch (Throwable e) {
            resp = RestResp.error((Integer)900000);
        }
        finally {
            this.exceptionHandler.logError(ex);
        }
        return resp;
    }

    public void setEnvironment(Environment environment) {
        this.order = (Integer)environment.getProperty("mcn.exception.handler.reactor.order", Integer.class, (Object)-1);
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public Integer resolve(Throwable ex) {
        if (ex instanceof ResponseStatusException) {
            return ExceptionKeys.mappingCode((Integer)((ResponseStatusException)ex).getRawStatusCode());
        }
        return null;
    }
}

