/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.reactor;

import cn.hiboot.mcn.core.model.result.RestResp;
import cn.hiboot.mcn.core.util.JacksonUtils;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import reactor.core.publisher.Mono;

public abstract class ServerHttpResponseUtils {
    public static Mono<Void> success(ServerHttpResponse response) {
        return ServerHttpResponseUtils.write(new RestResp(), response);
    }

    public static Mono<Void> success(Object data, ServerHttpResponse response) {
        return ServerHttpResponseUtils.write(new RestResp(data), response);
    }

    public static Mono<Void> failed(Throwable e, ServerHttpResponse response) {
        return ServerHttpResponseUtils.failed(e.getMessage(), response);
    }

    public static Mono<Void> failed(String msg, ServerHttpResponse response) {
        return ServerHttpResponseUtils.write(RestResp.error((String)msg), response);
    }

    public static Mono<Void> failed(Integer code, ServerHttpResponse response) {
        return ServerHttpResponseUtils.write(RestResp.error((Integer)code), response);
    }

    public static Mono<Void> write(RestResp<?> resp, ServerHttpResponse response) {
        response.setStatusCode(HttpStatus.OK);
        return ServerHttpResponseUtils.write(JacksonUtils.toJson(resp), response);
    }

    public static Mono<Void> write(String msg, ServerHttpResponse response) {
        if (msg == null) {
            msg = "";
        }
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        DataBuffer buffer = response.bufferFactory().wrap(msg.getBytes(StandardCharsets.UTF_8));
        return response.writeWith((Publisher)Mono.just((Object)buffer));
    }
}

