/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.security;

import cn.hiboot.mcn.autoconfigure.web.exception.ExceptionResolver;
import cn.hiboot.mcn.autoconfigure.web.security.WebSecurityProperties;
import cn.hiboot.mcn.core.model.result.RestResp;
import cn.hiboot.mcn.core.util.McnUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.handler.DefaultWebFilterChain;
import reactor.core.publisher.Mono;

@AutoConfiguration
@ConditionalOnClass(value={WebSecurity.class})
@EnableConfigurationProperties(value={WebSecurityProperties.class})
public class WebSecurityAutoConfiguration {
    private static List<String> ignoreUrl(WebSecurityProperties webSecurityProperties) {
        ArrayList<String> urls = new ArrayList<String>();
        if (webSecurityProperties.isEnableDefaultIgnore()) {
            Collections.addAll(urls, webSecurityProperties.getDefaultExcludeUrls());
        }
        if (webSecurityProperties.getExcludeUrls() != null) {
            Collections.addAll(urls, webSecurityProperties.getExcludeUrls());
        }
        return urls;
    }

    @Bean
    public ExceptionResolver<AccessDeniedException> securityExceptionResolver() {
        return t -> RestResp.error((Integer)800403);
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Configuration(proxyBeanMethods=false)
    @Import(value={IgnoreUrlFilter.class})
    static class ReactiveWebSecurityConfiguration {
        ReactiveWebSecurityConfiguration() {
        }

        @Order(value=-101)
        static class IgnoreUrlFilter
        implements WebFilter {
            private final ServerWebExchangeMatcher requiresAuthenticationMatcher;

            public IgnoreUrlFilter(WebSecurityProperties webSecurityProperties) {
                this.requiresAuthenticationMatcher = ServerWebExchangeMatchers.pathMatchers((String[])WebSecurityAutoConfiguration.ignoreUrl(webSecurityProperties).toArray(new String[0]));
            }

            public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
                return this.requiresAuthenticationMatcher.matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(m -> ((DefaultWebFilterChain)chain).getHandler().handle(exchange));
            }
        }
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Configuration(proxyBeanMethods=false)
    static class ServletWebSecurityConfiguration {
        ServletWebSecurityConfiguration() {
        }

        @Bean
        public WebSecurityCustomizer webSecurityCustomizer(WebSecurityProperties webSecurityProperties) {
            return web -> {
                List urls = WebSecurityAutoConfiguration.ignoreUrl(webSecurityProperties);
                if (McnUtils.isNotNullAndEmpty((Object)urls)) {
                    web.ignoring().requestMatchers(new RequestMatcher[]{new OrRequestMatcher(urls.stream().map(AntPathRequestMatcher::new).collect(Collectors.toList()))});
                }
            };
        }
    }
}

