/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.swagger;

import cn.hiboot.mcn.autoconfigure.web.swagger.DocketCustomizer;
import cn.hiboot.mcn.autoconfigure.web.swagger.IgnoreApi;
import cn.hiboot.mcn.autoconfigure.web.swagger.Swagger2Properties;
import cn.hiboot.mcn.autoconfigure.web.swagger.WebMvcRequestHandlerProvider;
import cn.hiboot.mcn.swagger.MvcSwagger2;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@AutoConfiguration
@EnableSwagger2
@EnableConfigurationProperties(value={Swagger2Properties.class})
@ConditionalOnClass(value={MvcSwagger2.class})
@ConditionalOnProperty(prefix="swagger", name={"enable"}, havingValue="true")
public class SwaggerAutoConfiguration {
    private final Swagger2Properties swagger2Properties;
    private final ObjectProvider<DocketCustomizer> docketCustomizers;
    private final Predicate<RequestHandler> DEFAULT_REQUEST_HANDLER = this.withClassAnnotation(RestController.class).and(this.withClassAnnotation(IgnoreApi.class).negate()).and(RequestHandlerSelectors.withMethodAnnotation(IgnoreApi.class).negate());

    public SwaggerAutoConfiguration(Swagger2Properties swagger2Properties, ObjectProvider<DocketCustomizer> docketCustomizers) {
        this.swagger2Properties = swagger2Properties;
        this.docketCustomizers = docketCustomizers;
    }

    private Predicate<RequestHandler> withClassAnnotation(Class<? extends Annotation> annotation) {
        return RequestHandlerSelectors.withClassAnnotation(annotation);
    }

    @Bean
    @ConditionalOnMissingBean
    public Docket createRestApi(Environment environment, ObjectProvider<ApiKey> apiKeys) {
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).enable(this.swagger2Properties.isEnable());
        List<ApiKey> apiKeyList = apiKeys.orderedStream().collect(Collectors.toList());
        if (Boolean.TRUE.equals(this.swagger2Properties.getHeader().getAuthorization()) || this.swagger2Properties.getHeader().getAuthorization() == null && ClassUtils.isPresent((String)"org.springframework.security.core.Authentication", null)) {
            apiKeyList.add(new ApiKey("JwtToken", "Authorization", "header"));
        }
        this.configApiKey(docket, apiKeyList);
        this.docketCustomizers.ifUnique(d -> d.customize(docket));
        this.configRequestParameters(docket, environment);
        return docket.select().apis(this.DEFAULT_REQUEST_HANDLER).paths(PathSelectors.any()).build();
    }

    private void configApiKey(Docket docket, List<ApiKey> apiKeys) {
        ArrayList<ApiKey> apiKeyList = new ArrayList<ApiKey>();
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        for (ApiKey apiKey : apiKeys) {
            apiKeyList.add(apiKey);
            securityReferences.add(this.buildSecurityReference(apiKey));
        }
        SecurityContext securityContext = SecurityContext.builder().securityReferences(securityReferences).operationSelector(p -> true).build();
        docket.securityContexts(Collections.singletonList(securityContext)).securitySchemes(apiKeyList);
    }

    private SecurityReference buildSecurityReference(ApiKey apiKey) {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return new SecurityReference(apiKey.getName(), authorizationScopes);
    }

    private void configRequestParameters(Docket docket, Environment environment) {
        ArrayList<RequestParameter> pars = new ArrayList<RequestParameter>();
        if (this.swagger2Properties.getHeader().isCsrf()) {
            pars.add(new RequestParameterBuilder().name("X-XSRF-TOKEN").description("csrf token").in(ParameterType.HEADER).query(s -> s.model(m -> m.scalarModel(ScalarType.STRING))).required(Boolean.valueOf(true)).build());
        }
        if (((Boolean)environment.getProperty("data.integrity.enable", Boolean.class, (Object)false)).booleanValue()) {
            pars.add(new RequestParameterBuilder().name("TSM").description("\u65f6\u95f4\u6233").in(ParameterType.HEADER).query(s -> s.model(m -> m.scalarModel(ScalarType.LONG))).required(Boolean.valueOf(true)).build());
            pars.add(new RequestParameterBuilder().name("nonceStr").description("\u968f\u673a\u5b57\u7b26\u4e32").in(ParameterType.HEADER).query(s -> s.model(m -> m.scalarModel(ScalarType.STRING))).required(Boolean.valueOf(true)).build());
            pars.add(new RequestParameterBuilder().name("signature").description("\u7b7e\u540d").in(ParameterType.HEADER).query(s -> s.model(m -> m.scalarModel(ScalarType.STRING))).required(Boolean.valueOf(true)).build());
        }
        docket.globalRequestParameters(pars);
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swagger2Properties.getTitle()).description(this.swagger2Properties.getDescription()).termsOfServiceUrl(this.swagger2Properties.getTermsOfServiceUrl()).contact(new Contact(this.swagger2Properties.getName(), this.swagger2Properties.getUrl(), this.swagger2Properties.getEmail())).version(this.swagger2Properties.getVersion()).build();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RequestHandlerProvider.class})
    protected static class CompatiblePathPatternParser
    implements BeanDefinitionRegistryPostProcessor,
    EnvironmentAware {
        static final String BEAN_NAME = "webMvcRequestHandlerProvider";
        private Environment environment;

        protected CompatiblePathPatternParser() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (registry.containsBeanDefinition(BEAN_NAME) && WebMvcProperties.MatchingStrategy.ANT_PATH_MATCHER != this.environment.getProperty("spring.mvc.pathmatch.matching-strategy", WebMvcProperties.MatchingStrategy.class)) {
                registry.removeBeanDefinition(BEAN_NAME);
                registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)new RootBeanDefinition(WebMvcRequestHandlerProvider.class));
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }
    }
}

