/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.web.swagger;

import cn.hiboot.mcn.autoconfigure.web.swagger.WebMvcRequestHandler;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.ServletContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

public class WebMvcRequestHandlerProvider
implements RequestHandlerProvider {
    private final List<RequestMappingInfoHandlerMapping> handlerMappings;
    private final HandlerMethodResolver methodResolver;
    private final String contextPath;

    public WebMvcRequestHandlerProvider(Optional<ServletContext> servletContext, HandlerMethodResolver methodResolver, List<RequestMappingInfoHandlerMapping> handlerMappings) {
        this.handlerMappings = handlerMappings;
        this.methodResolver = methodResolver;
        this.contextPath = servletContext.map(ServletContext::getContextPath).orElse("/");
    }

    public List<RequestHandler> requestHandlers() {
        return BuilderDefaults.nullToEmptyList(this.handlerMappings).stream().filter(requestMappingInfoHandlerMapping -> !"org.springframework.integration.http.inbound.IntegrationRequestMappingHandlerMapping".equals(requestMappingInfoHandlerMapping.getClass().getName())).map(this.toMappingEntries()).flatMap(entries -> StreamSupport.stream(entries.spliterator(), false)).map(this.toRequestHandler()).sorted(Orderings.byPatternsCondition()).collect(Collectors.toList());
    }

    private Function<RequestMappingInfoHandlerMapping, Iterable<Map.Entry<RequestMappingInfo, HandlerMethod>>> toMappingEntries() {
        return input -> input.getHandlerMethods().entrySet();
    }

    private Function<Map.Entry<RequestMappingInfo, HandlerMethod>, RequestHandler> toRequestHandler() {
        return input -> new WebMvcRequestHandler(this.contextPath, this.methodResolver, (RequestMappingInfo)input.getKey(), (HandlerMethod)input.getValue());
    }
}

