/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.cron.Scheduler;
import cn.hutool.cron.TaskExecutor;
import cn.hutool.cron.task.Task;
import java.util.ArrayList;
import java.util.List;

public class TaskExecutorManager {
    protected Scheduler scheduler;
    private List<TaskExecutor> executors = new ArrayList<TaskExecutor>();

    public TaskExecutorManager(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutor spawnExecutor(Task task) {
        TaskExecutor executor = new TaskExecutor(this.scheduler, task);
        List<TaskExecutor> list = this.executors;
        synchronized (list) {
            this.executors.add(executor);
        }
        executor.setDaemon(this.scheduler.daemon);
        executor.start();
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutorManager notifyExecutorCompleted(TaskExecutor executor) {
        List<TaskExecutor> list = this.executors;
        synchronized (list) {
            this.executors.remove(executor);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutorManager destroy() {
        List<TaskExecutor> list = this.executors;
        synchronized (list) {
            for (TaskExecutor taskExecutor : this.executors) {
                ThreadUtil.interupt(taskExecutor, true);
            }
        }
        this.executors.clear();
        return this;
    }
}

