/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.exceptions.POIException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkbookUtil {
    public static Workbook loadBook(String excelFilePath) {
        return WorkbookUtil.loadBook(FileUtil.file(excelFilePath), null);
    }

    public static Workbook loadBook(File excelFile) {
        return WorkbookUtil.loadBook(excelFile, null);
    }

    public static Workbook loadBook(File excelFile, String password) {
        return WorkbookUtil.loadBook(FileUtil.getInputStream(excelFile), password, true);
    }

    public static Workbook loadBook(InputStream in, boolean closeAfterRead) {
        return WorkbookUtil.loadBook(in, null, closeAfterRead);
    }

    public static Workbook loadBook(InputStream in, String password, boolean closeAfterRead) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)IoUtil.toMarkSupportStream(in), (String)password);
            return workbook;
        }
        catch (Exception e) {
            throw new POIException(e);
        }
        finally {
            if (closeAfterRead) {
                IoUtil.close(in);
            }
        }
    }

    public static Workbook createBook(String destFilePath) {
        Object workbook = StrUtil.endWithIgnoreCase(destFilePath, "xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
        return workbook;
    }

    public static Workbook createBook(File destFile) {
        return WorkbookUtil.createBook(destFile.getName());
    }

    public static void writeBook(Workbook book, OutputStream out) throws IORuntimeException {
        try {
            book.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

