/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.UrlResource;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import cn.hutool.setting.dialect.BasicSetting;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SettingLoader {
    private static Log log = LogFactory.get();
    private static final String COMMENT_FLAG_PRE = "#";
    private static final String ASSIGN_FLAG = "=";
    private static final char[] GROUP_SURROUND = new char[]{'[', ']'};
    private String reg_var = "\\$\\{(.*?)\\}";
    private Charset charset;
    private boolean isUseVariable;
    private BasicSetting setting;

    public SettingLoader(BasicSetting setting) {
        this(setting, CharsetUtil.CHARSET_UTF_8, false);
    }

    public SettingLoader(BasicSetting setting, Charset charset, boolean isUseVariable) {
        this.setting = setting;
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(UrlResource urlResource) {
        if (urlResource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", urlResource);
        InputStream settingStream = null;
        try {
            settingStream = urlResource.getStream();
            this.load(settingStream);
        }
        catch (Exception e) {
            log.error(e, "Load setting error!", new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            IoUtil.close(settingStream);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream settingStream) throws IOException {
        this.setting.clear();
        BufferedReader reader = null;
        try {
            String line;
            reader = IoUtil.getReader(settingStream, this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (StrUtil.isBlank(line = line.trim()) || line.startsWith(COMMENT_FLAG_PRE)) continue;
                if (line.charAt(0) == GROUP_SURROUND[0] && line.charAt(line.length() - 1) == GROUP_SURROUND[1]) {
                    group = line.substring(1, line.length() - 1).trim();
                    this.setting.getGroups().add(group);
                    continue;
                }
                String[] keyValue = line.split(ASSIGN_FLAG, 2);
                if (keyValue.length < 2) continue;
                String key = keyValue[0].trim();
                if (!StrUtil.isBlank(group)) {
                    key = group + "." + key;
                }
                String value = keyValue[1].trim();
                if (this.isUseVariable) {
                    value = this.replaceVar(value);
                }
                this.setting.put(key, value);
            }
        }
        catch (Throwable throwable) {
            IoUtil.close(reader);
            throw throwable;
        }
        IoUtil.close(reader);
        return true;
    }

    public void setVarRegex(String regex) {
        this.reg_var = regex;
    }

    public void store(String absolutePath) {
        boolean isFirst = true;
        BufferedWriter writer = null;
        try {
            writer = FileUtil.getWriter(absolutePath, this.charset, false);
            for (Map.Entry<Object, Object> entry : this.setting.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.newLine();
                }
                writer.write(StrUtil.format((CharSequence)"{} {} {}", entry.getKey(), ASSIGN_FLAG, entry.getValue()));
            }
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e, "Store Setting to [{}] error!", absolutePath);
            }
            catch (Throwable throwable) {
                IoUtil.close(writer);
                throw throwable;
            }
        }
        IoUtil.close(writer);
    }

    public void autoReload() {
    }

    private String replaceVar(String value) {
        Set vars = ReUtil.findAll(this.reg_var, value, 0, new HashSet());
        for (String var : vars) {
            Object varValue = this.setting.get(ReUtil.get(this.reg_var, var, 1));
            if (null == varValue || !(value instanceof CharSequence)) continue;
            value = value.replace(var, (CharSequence)varValue);
        }
        return value;
    }
}

