/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.tokenizer.engine;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.tokenizer.TokenizerEngine;
import cn.hutool.extra.tokenizer.TokenizerException;
import cn.hutool.extra.tokenizer.engine.analysis.SmartcnEngine;
import cn.hutool.extra.tokenizer.engine.ansj.AnsjEngine;
import cn.hutool.extra.tokenizer.engine.hanlp.HanLPEngine;
import cn.hutool.extra.tokenizer.engine.ikanalyzer.IKAnalyzerEngine;
import cn.hutool.extra.tokenizer.engine.jcseg.JcsegEngine;
import cn.hutool.extra.tokenizer.engine.jieba.JiebaEngine;
import cn.hutool.extra.tokenizer.engine.mmseg.MmsegEngine;
import cn.hutool.extra.tokenizer.engine.word.WordEngine;
import cn.hutool.log.StaticLog;

public class TokenizerFactory {
    public static TokenizerEngine create() {
        TokenizerEngine engine = TokenizerFactory.doCreate();
        StaticLog.debug("Use [{}] Tokenizer Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    private static TokenizerEngine doCreate() {
        try {
            return new AnsjEngine();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            try {
                return new HanLPEngine();
            }
            catch (NoClassDefFoundError noClassDefFoundError2) {
                try {
                    return new IKAnalyzerEngine();
                }
                catch (NoClassDefFoundError noClassDefFoundError3) {
                    try {
                        return new JcsegEngine();
                    }
                    catch (NoClassDefFoundError noClassDefFoundError4) {
                        try {
                            return new JiebaEngine();
                        }
                        catch (NoClassDefFoundError noClassDefFoundError5) {
                            try {
                                return new MmsegEngine();
                            }
                            catch (NoClassDefFoundError noClassDefFoundError6) {
                                try {
                                    return new WordEngine();
                                }
                                catch (NoClassDefFoundError noClassDefFoundError7) {
                                    try {
                                        return new SmartcnEngine();
                                    }
                                    catch (NoClassDefFoundError noClassDefFoundError8) {
                                        throw new TokenizerException("No tokenizer found ! Please add some tokenizer jar to your project !");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

