/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReflectUtil {
    private static final SimpleCache<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Field[]> FIELDS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Method[]> METHODS_CACHE = new SimpleCache();

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = ReflectUtil.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtil.isAllAssignableFrom(pts, parameterTypes)) continue;
            constructor.setAccessible(true);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        Constructor<?>[] constructors = CONSTRUCTORS_CACHE.get(beanClass);
        if (null != constructors) {
            return constructors;
        }
        constructors = ReflectUtil.getConstructorsDirectly(beanClass);
        return CONSTRUCTORS_CACHE.put(beanClass, constructors);
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return beanClass.getDeclaredConstructors();
    }

    public static boolean hasField(Class<?> beanClass, String name) throws SecurityException {
        return null != ReflectUtil.getField(beanClass, name);
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = ReflectUtil.getFields(beanClass);
        if (ArrayUtil.isNotEmpty(fields)) {
            for (Field field : fields) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Field[] allFields = FIELDS_CACHE.get(beanClass);
        if (null != allFields) {
            return allFields;
        }
        allFields = ReflectUtil.getFieldsDirectly(beanClass, true);
        return FIELDS_CACHE.put(beanClass, allFields);
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFieds) throws SecurityException {
        Assert.notNull(beanClass);
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = null == allFields ? declaredFields : ArrayUtil.append(allFields, declaredFields);
            searchType = withSuperClassFieds ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static Object getFieldValue(Object obj, String fieldName) throws UtilException {
        if (null == obj || StrUtil.isBlank(fieldName)) {
            return null;
        }
        return ReflectUtil.getFieldValue(obj, ReflectUtil.getField(obj.getClass(), fieldName));
    }

    public static Object getFieldValue(Object obj, Field field) throws UtilException {
        if (null == obj || null == field) {
            return null;
        }
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e, "IllegalAccess for {}.{}", obj.getClass(), field.getName());
        }
        return result;
    }

    public static Object[] getFieldsValue(Object obj) {
        Field[] fields;
        if (null != obj && null != (fields = ReflectUtil.getFields(obj.getClass()))) {
            Object[] values = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                values[i] = ReflectUtil.getFieldValue(obj, fields[i]);
            }
            return values;
        }
        return null;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws UtilException {
        Assert.notNull(obj);
        Assert.notBlank(fieldName);
        ReflectUtil.setFieldValue(obj, ReflectUtil.getField(obj.getClass(), fieldName), value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws UtilException {
        Object targetValue;
        Class<?> fieldType;
        Assert.notNull(obj);
        Assert.notNull(field);
        field.setAccessible(true);
        if (null != value && !(fieldType = field.getType()).isAssignableFrom(value.getClass()) && null != (targetValue = Convert.convert(fieldType, value))) {
            value = targetValue;
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e, "IllegalAccess for {}.{}", obj.getClass(), field.getName());
        }
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        HashSet<String> methodSet = new HashSet<String>();
        Method[] methodArray = ReflectUtil.getPublicMethods(clazz);
        if (ArrayUtil.isNotEmpty(methodArray)) {
            for (Method method : methodArray) {
                methodSet.add(method.getName());
            }
        }
        return methodSet;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return null == clazz ? null : clazz.getMethods();
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        ArrayList<Method> methodList;
        if (null == clazz) {
            return null;
        }
        Method[] methods = ReflectUtil.getPublicMethods(clazz);
        if (null != filter) {
            methodList = new ArrayList();
            for (Method method : methods) {
                if (!filter.accept(method)) continue;
                methodList.add(method);
            }
        } else {
            methodList = CollectionUtil.newArrayList(methods);
        }
        return methodList;
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        final HashSet<Method> excludeMethodSet = CollectionUtil.newHashSet(excludeMethods);
        return ReflectUtil.getPublicMethods(clazz, new Filter<Method>(){

            @Override
            public boolean accept(Method method) {
                return false == excludeMethodSet.contains(method);
            }
        });
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        final HashSet<String> excludeMethodNameSet = CollectionUtil.newHashSet(excludeMethodNames);
        return ReflectUtil.getPublicMethods(clazz, new Filter<Method>(){

            @Override
            public boolean accept(Method method) {
                return false == excludeMethodNameSet.contains(method.getName());
            }
        });
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || StrUtil.isBlank(methodName)) {
            return null;
        }
        return ReflectUtil.getMethod(obj.getClass(), methodName, ClassUtil.getClasses(args));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method[] methods = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase) || !ClassUtil.isAllAssignableFrom(method.getParameterTypes(), paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtil.getMethodByName(clazz, false, methodName);
    }

    public static Method getMethodByNameIgnoreCase(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtil.getMethodByName(clazz, true, methodName);
    }

    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method[] methods = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase)) continue;
                return method;
            }
        }
        return null;
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        Method[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods = ReflectUtil.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method[] getMethods(Class<?> clazz, Filter<Method> filter) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return ArrayUtil.filter(ReflectUtil.getMethods(clazz), filter);
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Method[] allMethods = METHODS_CACHE.get(beanClass);
        if (null != allMethods) {
            return allMethods;
        }
        allMethods = ReflectUtil.getMethodsDirectly(beanClass, true);
        return METHODS_CACHE.put(beanClass, allMethods);
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSuperClassMethods) throws SecurityException {
        Assert.notNull(beanClass);
        Method[] allMethods = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Method[] declaredMethods = searchType.getDeclaredMethods();
            allMethods = null == allMethods ? declaredMethods : ArrayUtil.append(allMethods, declaredMethods);
            searchType = withSuperClassMethods ? searchType.getSuperclass() : null;
        }
        return allMethods;
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return 1 == paramTypes.length && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static <T> T newInstance(String clazz) throws UtilException {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new UtilException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws UtilException {
        if (ArrayUtil.isEmpty(params)) {
            Constructor<T> constructor = ReflectUtil.getConstructor(clazz, new Class[0]);
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new UtilException(e, "Instance class [{}] error!", clazz);
            }
        }
        Class<?>[] paramTypes = ClassUtil.getClasses(params);
        Constructor<T> constructor = ReflectUtil.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new UtilException("No Constructor matched for parameter types: [{}]", new Object[]{paramTypes});
        }
        try {
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new UtilException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> beanClass) {
        Assert.notNull(beanClass);
        try {
            return ReflectUtil.newInstance(beanClass, new Object[0]);
        }
        catch (Exception e) {
            Constructor<T>[] constructors;
            for (Constructor<T> constructor : constructors = ReflectUtil.getConstructors(beanClass)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                constructor.setAccessible(true);
                try {
                    return constructor.newInstance(ClassUtil.getDefaultValues(parameterTypes));
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws UtilException {
        return ReflectUtil.invoke(null, method, args);
    }

    public static <T> T invokeWithCheck(Object obj, Method method, Object ... args) throws UtilException {
        Class<?>[] types = method.getParameterTypes();
        if (null != types && null != args) {
            Assert.isTrue(args.length == types.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, types.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = types[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = ClassUtil.getDefaultValue(type);
            }
        }
        return ReflectUtil.invoke(obj, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws UtilException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return (T)method.invoke(ClassUtil.isStatic(method) ? null : obj, args);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) throws UtilException {
        Method method = ReflectUtil.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new UtilException(StrUtil.format((CharSequence)"No such method: [{}]", methodName));
        }
        return ReflectUtil.invoke(obj, method, args);
    }
}

