/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest.mac;

import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.digest.mac.MacEngine;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class BCHMacEngine
implements MacEngine {
    private Mac mac;

    public BCHMacEngine(Digest digest, byte[] key) {
        this(digest, (CipherParameters)new KeyParameter(key));
    }

    public BCHMacEngine(Digest digest, CipherParameters params) {
        this.init(digest, params);
    }

    public BCHMacEngine init(Digest digest, CipherParameters params) {
        this.mac = new HMac(digest);
        this.mac.init(params);
        return this;
    }

    @Override
    public byte[] digest(InputStream data, int bufferLength) {
        byte[] result;
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        byte[] buffer = new byte[bufferLength];
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.mac.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            result = new byte[this.mac.getMacSize()];
            this.mac.doFinal(result, 0);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public Mac getMac() {
        return this.mac;
    }

    @Override
    public int getMacLength() {
        return this.mac.getMacSize();
    }

    @Override
    public String getAlgorithm() {
        return this.mac.getAlgorithmName();
    }
}

