/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha.generator;

import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.core.math.Calculator;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

public class MathGenerator
implements CodeGenerator {
    private static final long serialVersionUID = -5514819971774091076L;
    private static final String operators = "+-*";
    private final int numberLength;
    private final boolean resultHasNegativeNumber;

    public MathGenerator() {
        this(2, true);
    }

    public MathGenerator(boolean resultHasNegativeNumber) {
        this(2, resultHasNegativeNumber);
    }

    public MathGenerator(int numberLength) {
        this(numberLength, true);
    }

    public MathGenerator(int numberLength, boolean resultHasNegativeNumber) {
        this.numberLength = numberLength;
        this.resultHasNegativeNumber = resultHasNegativeNumber;
    }

    @Override
    public String generate() {
        int limit = this.getLimit();
        char operator = RandomUtil.randomChar(operators);
        int numberInt1 = 0;
        int numberInt2 = 0;
        numberInt1 = RandomUtil.randomInt(limit);
        numberInt2 = !this.resultHasNegativeNumber && CharUtil.equals('-', operator, false) ? (numberInt1 == 0 ? 0 : RandomUtil.randomInt(0, numberInt1)) : RandomUtil.randomInt(limit);
        String number1 = Integer.toString(numberInt1);
        String number2 = Integer.toString(numberInt2);
        number1 = StrUtil.padAfter((CharSequence)number1, this.numberLength, ' ');
        number2 = StrUtil.padAfter((CharSequence)number2, this.numberLength, ' ');
        return StrUtil.builder().append(number1).append(operator).append(number2).append('=').toString();
    }

    @Override
    public boolean verify(String code, String userInputCode) {
        int result;
        try {
            result = Integer.parseInt(userInputCode);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int calculateResult = (int)Calculator.conversion(code);
        return result == calculateResult;
    }

    public int getLength() {
        return this.numberLength * 2 + 2;
    }

    private int getLimit() {
        return Integer.parseInt("1" + StrUtil.repeat('0', this.numberLength));
    }
}

