/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.PropIgnore;
import cn.hutool.core.bean.BeanException;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ModifierUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.TypeUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class PropDesc {
    private static final String TRANSIENT_CLASS_NAME = "java.beans.Transient";
    final Field field;
    protected Method getter;
    protected Method setter;
    private boolean transientForGet;
    private boolean transientForSet;
    private boolean ignoreGet;
    private boolean ignoreSet;

    public PropDesc(Field field, Method getter, Method setter) {
        this.field = field;
        this.getter = ClassUtil.setAccessible(getter);
        this.setter = ClassUtil.setAccessible(setter);
    }

    public void initialize() {
        this.transientForGet = this.isTransientForGet();
        this.transientForSet = this.isTransientForSet();
        this.ignoreGet = this.isIgnoreGet();
        this.ignoreSet = this.isIgnoreSet();
    }

    public String getFieldName() {
        return ReflectUtil.getFieldName(this.field);
    }

    public String getRawFieldName() {
        return null == this.field ? null : this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public Type getFieldType() {
        if (null != this.field) {
            return TypeUtil.getType(this.field);
        }
        return this.findPropType(this.getter, this.setter);
    }

    public Class<?> getFieldClass() {
        if (null != this.field) {
            return TypeUtil.getClass(this.field);
        }
        return this.findPropClass(this.getter, this.setter);
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public boolean isReadable(boolean checkTransient) {
        if (null == this.getter && !ModifierUtil.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.transientForGet) {
            return false;
        }
        return false == this.ignoreGet;
    }

    public Object getValue(Object bean) {
        if (null != this.getter) {
            return ReflectUtil.invoke(bean, this.getter, new Object[0]);
        }
        if (ModifierUtil.isPublic(this.field)) {
            return ReflectUtil.getFieldValue(bean, this.field);
        }
        return null;
    }

    public Object getValue(Object bean, Type targetType, boolean ignoreError) {
        Object result;
        block3: {
            result = null;
            try {
                result = this.getValue(bean);
            }
            catch (Exception e) {
                if (ignoreError) break block3;
                throw new BeanException(e, "Get value of [{}] error!", this.getFieldName());
            }
        }
        if (null != result && null != targetType) {
            return Convert.convertWithCheck(targetType, result, null, ignoreError);
        }
        return result;
    }

    public boolean isWritable(boolean checkTransient) {
        if (null == this.setter && !ModifierUtil.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.transientForSet) {
            return false;
        }
        return false == this.ignoreSet;
    }

    public PropDesc setValue(Object bean, Object value) {
        if (null != this.setter) {
            ReflectUtil.invoke(bean, this.setter, value);
        } else if (ModifierUtil.isPublic(this.field)) {
            ReflectUtil.setFieldValue(bean, this.field, value);
        }
        return this;
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError) {
        return this.setValue(bean, value, ignoreNull, ignoreError, true);
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError, boolean override) {
        block6: {
            Class<?> propClass;
            if (null == value && ignoreNull) {
                return this;
            }
            if (!override && null != this.getValue(bean)) {
                return this;
            }
            if (null != value && !(propClass = this.getFieldClass()).isInstance(value)) {
                value = Convert.convertWithCheck(propClass, value, null, ignoreError);
            }
            if (null != value || !ignoreNull) {
                try {
                    this.setValue(bean, value);
                }
                catch (Exception e) {
                    if (ignoreError) break block6;
                    throw new BeanException(e, "Set value of [{}] error!", this.getFieldName());
                }
            }
        }
        return this;
    }

    private Type findPropType(Method getter, Method setter) {
        Type type = null;
        if (null != getter) {
            type = TypeUtil.getReturnType(getter);
        }
        if (null == type && null != setter) {
            type = TypeUtil.getParamType(setter, 0);
        }
        return type;
    }

    private Class<?> findPropClass(Method getter, Method setter) {
        Class<?> type = null;
        if (null != getter) {
            type = TypeUtil.getReturnClass(getter);
        }
        if (null == type && null != setter) {
            type = TypeUtil.getFirstParamClass(setter);
        }
        return type;
    }

    private boolean isIgnoreSet() {
        return AnnotationUtil.hasAnnotation((AnnotatedElement)this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation((AnnotatedElement)this.setter, PropIgnore.class);
    }

    private boolean isIgnoreGet() {
        return AnnotationUtil.hasAnnotation((AnnotatedElement)this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation((AnnotatedElement)this.getter, PropIgnore.class);
    }

    private boolean isTransientForGet() {
        boolean isTransient = ModifierUtil.hasModifier(this.field, ModifierUtil.ModifierType.TRANSIENT);
        if (!isTransient && null != this.getter && !(isTransient = ModifierUtil.hasModifier(this.getter, ModifierUtil.ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation((AnnotatedElement)this.getter, TRANSIENT_CLASS_NAME);
        }
        return isTransient;
    }

    private boolean isTransientForSet() {
        boolean isTransient = ModifierUtil.hasModifier(this.field, ModifierUtil.ModifierType.TRANSIENT);
        if (!isTransient && null != this.setter && !(isTransient = ModifierUtil.hasModifier(this.setter, ModifierUtil.ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation((AnnotatedElement)this.setter, TRANSIENT_CLASS_NAME);
        }
        return isTransient;
    }
}

