/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log;

import cn.hutool.core.lang.caller.CallerUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.LocationAwareLog;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import cn.hutool.log.level.Level;

public final class StaticLog {
    private static final String FQCN = StaticLog.class.getName();

    private StaticLog() {
    }

    public static void trace(String format, Object ... arguments) {
        StaticLog.trace(LogFactory.get(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void trace(Log log, String format, Object ... arguments) {
        if (!StaticLog.log(log, Level.TRACE, null, format, arguments)) {
            log.trace(format, arguments);
        }
    }

    public static void debug(String format, Object ... arguments) {
        StaticLog.debug(LogFactory.get(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void debug(Log log, String format, Object ... arguments) {
        if (!StaticLog.log(log, Level.DEBUG, null, format, arguments)) {
            log.debug(format, arguments);
        }
    }

    public static void info(String format, Object ... arguments) {
        StaticLog.info(LogFactory.get(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void info(Log log, String format, Object ... arguments) {
        if (!StaticLog.log(log, Level.INFO, null, format, arguments)) {
            log.info(format, arguments);
        }
    }

    public static void warn(String format, Object ... arguments) {
        StaticLog.warn(LogFactory.get(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void warn(Throwable e, String format, Object ... arguments) {
        StaticLog.warn(LogFactory.get(CallerUtil.getCallerCaller()), e, StrUtil.format((CharSequence)format, (Object[])arguments), new Object[0]);
    }

    public static void warn(Log log, String format, Object ... arguments) {
        StaticLog.warn(log, null, format, arguments);
    }

    public static void warn(Log log, Throwable e, String format, Object ... arguments) {
        if (!StaticLog.log(log, Level.WARN, e, format, arguments)) {
            log.warn(e, format, arguments);
        }
    }

    public static void error(Throwable e) {
        StaticLog.error(LogFactory.get(CallerUtil.getCallerCaller()), e);
    }

    public static void error(String format, Object ... arguments) {
        StaticLog.error(LogFactory.get(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void error(Throwable e, String format, Object ... arguments) {
        StaticLog.error(LogFactory.get(CallerUtil.getCallerCaller()), e, format, arguments);
    }

    public static void error(Log log, Throwable e) {
        StaticLog.error(log, e, e.getMessage(), new Object[0]);
    }

    public static void error(Log log, String format, Object ... arguments) {
        StaticLog.error(log, null, format, arguments);
    }

    public static void error(Log log, Throwable e, String format, Object ... arguments) {
        if (!StaticLog.log(log, Level.ERROR, e, format, arguments)) {
            log.error(e, format, arguments);
        }
    }

    public static boolean log(Level level, Throwable t, String format, Object ... arguments) {
        return StaticLog.log(LogFactory.get(CallerUtil.getCallerCaller()), level, t, format, arguments);
    }

    public static boolean log(Log log, Level level, Throwable t, String format, Object ... arguments) {
        if (log instanceof LocationAwareLog) {
            ((LocationAwareLog)log).log(FQCN, level, t, format, arguments);
            return true;
        }
        return false;
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.get(clazz);
    }

    public static Log get(String name) {
        return LogFactory.get(name);
    }

    public static Log get() {
        return LogFactory.get(CallerUtil.getCallerCaller());
    }
}

