/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.metadata.data;

import cn.idev.excel.constant.FastExcelConstants;
import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.metadata.data.CellData;
import cn.idev.excel.metadata.data.DataFormatData;
import java.math.BigDecimal;

public class ReadCellData<T>
extends CellData<T> {
    private BigDecimal originalNumberValue;
    private DataFormatData dataFormatData;

    public ReadCellData(CellDataTypeEnum type) {
        if (type == null) {
            throw new IllegalArgumentException("Type can not be null");
        }
        this.setType(type);
    }

    public ReadCellData(T data) {
        this.setData(data);
    }

    public ReadCellData(String stringValue) {
        this(CellDataTypeEnum.STRING, stringValue);
    }

    public ReadCellData(CellDataTypeEnum type, String stringValue) {
        if (type != CellDataTypeEnum.STRING && type != CellDataTypeEnum.ERROR) {
            throw new IllegalArgumentException("Only support CellDataTypeEnum.STRING and  CellDataTypeEnum.ERROR");
        }
        if (stringValue == null) {
            throw new IllegalArgumentException("StringValue can not be null");
        }
        this.setType(type);
        this.setStringValue(stringValue);
    }

    public ReadCellData(BigDecimal numberValue) {
        if (numberValue == null) {
            throw new IllegalArgumentException("DoubleValue can not be null");
        }
        this.setType(CellDataTypeEnum.NUMBER);
        this.setNumberValue(numberValue);
    }

    public ReadCellData(Boolean booleanValue) {
        if (booleanValue == null) {
            throw new IllegalArgumentException("BooleanValue can not be null");
        }
        this.setType(CellDataTypeEnum.BOOLEAN);
        this.setBooleanValue(booleanValue);
    }

    public static ReadCellData<?> newEmptyInstance() {
        return ReadCellData.newEmptyInstance(null, null);
    }

    public static ReadCellData<?> newEmptyInstance(Integer rowIndex, Integer columnIndex) {
        ReadCellData<CellDataTypeEnum> cellData = new ReadCellData<CellDataTypeEnum>(CellDataTypeEnum.EMPTY);
        cellData.setRowIndex(rowIndex);
        cellData.setColumnIndex(columnIndex);
        return cellData;
    }

    public static ReadCellData<?> newInstance(Boolean booleanValue) {
        return ReadCellData.newInstance(booleanValue, null, null);
    }

    public static ReadCellData<?> newInstance(Boolean booleanValue, Integer rowIndex, Integer columnIndex) {
        ReadCellData cellData = new ReadCellData(booleanValue);
        cellData.setRowIndex(rowIndex);
        cellData.setColumnIndex(columnIndex);
        return cellData;
    }

    public static ReadCellData<?> newInstance(String stringValue, Integer rowIndex, Integer columnIndex) {
        ReadCellData cellData = new ReadCellData(stringValue);
        cellData.setRowIndex(rowIndex);
        cellData.setColumnIndex(columnIndex);
        return cellData;
    }

    public static ReadCellData<?> newInstance(BigDecimal numberValue, Integer rowIndex, Integer columnIndex) {
        ReadCellData cellData = new ReadCellData(numberValue);
        cellData.setRowIndex(rowIndex);
        cellData.setColumnIndex(columnIndex);
        return cellData;
    }

    public static ReadCellData<?> newInstanceOriginal(BigDecimal numberValue, Integer rowIndex, Integer columnIndex) {
        ReadCellData cellData = new ReadCellData(numberValue);
        cellData.setRowIndex(rowIndex);
        cellData.setColumnIndex(columnIndex);
        cellData.setOriginalNumberValue(numberValue);
        cellData.setNumberValue(numberValue.round(FastExcelConstants.EXCEL_MATH_CONTEXT));
        return cellData;
    }

    public ReadCellData<Object> clone() {
        ReadCellData<Object> readCellData = new ReadCellData<Object>();
        readCellData.setType(this.getType());
        readCellData.setNumberValue(this.getNumberValue());
        readCellData.setOriginalNumberValue(this.getOriginalNumberValue());
        readCellData.setStringValue(this.getStringValue());
        readCellData.setBooleanValue(this.getBooleanValue());
        readCellData.setData(this.getData());
        if (this.getDataFormatData() != null) {
            readCellData.setDataFormatData(this.getDataFormatData().clone());
        }
        if (this.getFormulaData() != null) {
            readCellData.setFormulaData(this.getFormulaData().clone());
        }
        return readCellData;
    }

    public BigDecimal getOriginalNumberValue() {
        return this.originalNumberValue;
    }

    public DataFormatData getDataFormatData() {
        return this.dataFormatData;
    }

    public void setOriginalNumberValue(BigDecimal originalNumberValue) {
        this.originalNumberValue = originalNumberValue;
    }

    public void setDataFormatData(DataFormatData dataFormatData) {
        this.dataFormatData = dataFormatData;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadCellData)) {
            return false;
        }
        ReadCellData other = (ReadCellData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BigDecimal this$originalNumberValue = this.getOriginalNumberValue();
        BigDecimal other$originalNumberValue = other.getOriginalNumberValue();
        if (this$originalNumberValue == null ? other$originalNumberValue != null : !((Object)this$originalNumberValue).equals(other$originalNumberValue)) {
            return false;
        }
        DataFormatData this$dataFormatData = this.getDataFormatData();
        DataFormatData other$dataFormatData = other.getDataFormatData();
        return !(this$dataFormatData == null ? other$dataFormatData != null : !((Object)this$dataFormatData).equals(other$dataFormatData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReadCellData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BigDecimal $originalNumberValue = this.getOriginalNumberValue();
        result = result * 59 + ($originalNumberValue == null ? 43 : ((Object)$originalNumberValue).hashCode());
        DataFormatData $dataFormatData = this.getDataFormatData();
        result = result * 59 + ($dataFormatData == null ? 43 : ((Object)$dataFormatData).hashCode());
        return result;
    }

    public ReadCellData() {
    }
}

