/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.handler;

import cn.idev.excel.support.ExcelTypeEnum;
import cn.idev.excel.write.handler.WriteHandler;
import cn.idev.excel.write.handler.impl.DefaultRowWriteHandler;
import cn.idev.excel.write.handler.impl.DimensionWorkbookWriteHandler;
import cn.idev.excel.write.handler.impl.FillStyleCellWriteHandler;
import cn.idev.excel.write.handler.impl.WriteSheetWorkbookWriteHandler;
import cn.idev.excel.write.style.DefaultStyle;
import java.util.ArrayList;
import java.util.List;

public class DefaultWriteHandlerLoader {
    public static final List<WriteHandler> DEFAULT_WRITE_HANDLER_LIST = new ArrayList<WriteHandler>();

    public static List<WriteHandler> loadDefaultHandler(Boolean useDefaultStyle, ExcelTypeEnum excelType) {
        ArrayList<WriteHandler> handlerList = new ArrayList<WriteHandler>();
        switch (excelType) {
            case XLSX: {
                handlerList.add(new DimensionWorkbookWriteHandler());
                handlerList.add(new DefaultRowWriteHandler());
                handlerList.add(new FillStyleCellWriteHandler());
                handlerList.add(new WriteSheetWorkbookWriteHandler());
                if (!useDefaultStyle.booleanValue()) break;
                handlerList.add(new DefaultStyle());
                break;
            }
            case XLS: {
                handlerList.add(new DefaultRowWriteHandler());
                handlerList.add(new FillStyleCellWriteHandler());
                handlerList.add(new WriteSheetWorkbookWriteHandler());
                if (!useDefaultStyle.booleanValue()) break;
                handlerList.add(new DefaultStyle());
                break;
            }
            case CSV: {
                handlerList.add(new DefaultRowWriteHandler());
                handlerList.add(new FillStyleCellWriteHandler());
                break;
            }
        }
        return handlerList;
    }

    static {
        DEFAULT_WRITE_HANDLER_LIST.add(new DimensionWorkbookWriteHandler());
        DEFAULT_WRITE_HANDLER_LIST.add(new DefaultRowWriteHandler());
        DEFAULT_WRITE_HANDLER_LIST.add(new FillStyleCellWriteHandler());
    }
}

