/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.service.impl.alipay;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.lly835.bestpay.config.AliPayConfig;
import com.lly835.bestpay.config.SignType;
import com.lly835.bestpay.enums.AlipayTradeStatusEnum;
import com.lly835.bestpay.enums.BestPayPlatformEnum;
import com.lly835.bestpay.model.DownloadBillRequest;
import com.lly835.bestpay.model.OrderQueryRequest;
import com.lly835.bestpay.model.OrderQueryResponse;
import com.lly835.bestpay.model.PayRequest;
import com.lly835.bestpay.model.PayResponse;
import com.lly835.bestpay.model.RefundRequest;
import com.lly835.bestpay.model.RefundResponse;
import com.lly835.bestpay.model.alipay.AliPayApi;
import com.lly835.bestpay.model.alipay.request.AliPayOrderQueryRequest;
import com.lly835.bestpay.model.alipay.request.AliPayPcRequest;
import com.lly835.bestpay.model.alipay.response.AliPayAsyncResponse;
import com.lly835.bestpay.model.alipay.response.AliPayOrderQueryResponse;
import com.lly835.bestpay.service.impl.BestPayServiceImpl;
import com.lly835.bestpay.service.impl.alipay.AliPaySignature;
import com.lly835.bestpay.utils.JsonUtil;
import com.lly835.bestpay.utils.MapUtil;
import com.lly835.bestpay.utils.WebUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class AliPayServiceImpl
extends BestPayServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AliPayServiceImpl.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private AliPayConfig aliPayConfig;
    private Retrofit retrofit = new Retrofit.Builder().baseUrl("https://openapi.alipay.com/").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create())).client(new OkHttpClient.Builder().addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY)).build()).build();

    @Override
    public void setAliPayConfig(AliPayConfig aliPayConfig) {
        this.aliPayConfig = aliPayConfig;
    }

    @Override
    public PayResponse pay(PayRequest request) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("out_trade_no", request.getOrderId());
        requestParams.put("product_code", "FAST_INSTANT_TRADE_PAY");
        requestParams.put("total_amount", String.valueOf(request.getOrderAmount()));
        requestParams.put("subject", String.valueOf(request.getOrderName()));
        AliPayPcRequest aliPayRequest = new AliPayPcRequest();
        aliPayRequest.setAppId(this.aliPayConfig.getAppId());
        aliPayRequest.setCharset("utf-8");
        aliPayRequest.setMethod("alipay.trade.page.pay");
        aliPayRequest.setSignType("RSA2");
        aliPayRequest.setNotifyUrl(this.aliPayConfig.getNotifyUrl());
        aliPayRequest.setReturnUrl(this.aliPayConfig.getReturnUrl());
        aliPayRequest.setTimestamp(LocalDateTime.now().format(formatter));
        aliPayRequest.setVersion("1.0");
        aliPayRequest.setBizContent(JsonUtil.toJson(requestParams).replaceAll("\\s*", ""));
        aliPayRequest.setSign(AliPaySignature.sign(MapUtil.object2MapWithUnderline(aliPayRequest), this.aliPayConfig.getPrivateKey()));
        Map<String, String> parameters = MapUtil.object2MapWithUnderline(aliPayRequest);
        HashMap<String, String> applicationParams = new HashMap<String, String>();
        applicationParams.put("biz_content", aliPayRequest.getBizContent());
        parameters.remove("biz_content");
        String baseUrl = WebUtil.getRequestUrl(parameters, this.aliPayConfig.isSandbox());
        String body = WebUtil.buildForm(baseUrl, applicationParams);
        PayResponse response = new PayResponse();
        response.setBody(body);
        return response;
    }

    @Override
    public boolean verify(Map<String, String> toBeVerifiedParamMap, SignType signType, String sign) {
        return AliPaySignature.verify(toBeVerifiedParamMap, this.aliPayConfig.getAliPayPublicKey());
    }

    @Override
    public PayResponse asyncNotify(String notifyData) {
        try {
            notifyData = URLDecoder.decode(notifyData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (!AliPaySignature.verify(MapUtil.form2Map(notifyData), this.aliPayConfig.getAliPayPublicKey()).booleanValue()) {
            log.error("\u3010\u652f\u4ed8\u5b9d\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u3011\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25, response={}", (Object)notifyData);
            throw new RuntimeException("\u3010\u652f\u4ed8\u5b9d\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u3011\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        HashMap<String, String> params = MapUtil.form2MapWithCamelCase(notifyData);
        AliPayAsyncResponse response = MapUtil.mapToObject(params, AliPayAsyncResponse.class);
        String tradeStatus = response.getTradeStatus();
        if (!tradeStatus.equals("TRADE_FINISHED") && !tradeStatus.equals("TRADE_SUCCESS")) {
            throw new RuntimeException("\u3010\u652f\u4ed8\u5b9d\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u3011\u53d1\u8d77\u652f\u4ed8, trade_status != SUCCESS | FINISHED");
        }
        return this.buildPayResponse(response);
    }

    @Override
    public RefundResponse refund(RefundRequest request) {
        return super.refund(request);
    }

    @Override
    public OrderQueryResponse query(OrderQueryRequest request) {
        AliPayOrderQueryRequest aliPayOrderQueryRequest = new AliPayOrderQueryRequest();
        aliPayOrderQueryRequest.setAppId(this.aliPayConfig.getAppId());
        aliPayOrderQueryRequest.setTimestamp(LocalDateTime.now().format(formatter));
        AliPayOrderQueryRequest.BizContent bizContent = new AliPayOrderQueryRequest.BizContent();
        bizContent.setOutTradeNo(request.getOrderId());
        bizContent.setTradeNo(request.getOutOrderId());
        aliPayOrderQueryRequest.setBizContent(JsonUtil.toJsonWithUnderscores(bizContent).replaceAll("\\s*", ""));
        aliPayOrderQueryRequest.setSign(AliPaySignature.sign(MapUtil.object2MapWithUnderline(aliPayOrderQueryRequest), this.aliPayConfig.getPrivateKey()));
        Call<AliPayOrderQueryResponse> call = ((AliPayApi)this.retrofit.create(AliPayApi.class)).orderQuery(MapUtil.object2MapWithUnderline(aliPayOrderQueryRequest));
        Response retrofitResponse = null;
        try {
            retrofitResponse = call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (retrofitResponse != null);
        if (!retrofitResponse.isSuccessful()) {
            throw new RuntimeException("\u3010\u67e5\u8be2\u652f\u4ed8\u5b9d\u8ba2\u5355\u3011\u7f51\u7edc\u5f02\u5e38");
        }
        assert (retrofitResponse.body() != null);
        AliPayOrderQueryResponse.AlipayTradeQueryResponse response = ((AliPayOrderQueryResponse)retrofitResponse.body()).getAlipayTradeQueryResponse();
        if (!response.getCode().equals("10000")) {
            throw new RuntimeException("\u3010\u67e5\u8be2\u652f\u4ed8\u5b9d\u8ba2\u5355\u3011code=" + response.getCode() + ", returnMsg=" + response.getMsg() + String.format("|%s|%s", response.getSubCode(), response.getSubMsg()));
        }
        return OrderQueryResponse.builder().orderStatusEnum(AlipayTradeStatusEnum.findByName(response.getTradeStatus()).getOrderStatusEnum()).outTradeNo(response.getTradeNo()).orderId(response.getOutTradeNo()).resultMsg(response.getMsg()).finishTime(response.getSendPayDate()).build();
    }

    @Override
    public String downloadBill(DownloadBillRequest request) {
        return super.downloadBill(request);
    }

    private PayResponse buildPayResponse(AliPayAsyncResponse response) {
        PayResponse payResponse = new PayResponse();
        payResponse.setPayPlatformEnum(BestPayPlatformEnum.ALIPAY);
        payResponse.setOrderAmount(Double.valueOf(response.getTotalAmount()));
        payResponse.setOrderId(response.getOutTradeNo());
        payResponse.setOutTradeNo(response.getTradeNo());
        return payResponse;
    }
}

