/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.service.impl.alipay;

import com.lly835.bestpay.utils.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliPaySignature {
    private static final Logger log = LoggerFactory.getLogger(AliPaySignature.class);

    public static String sign(Map<String, String> params, String privateKey) {
        String signType = params.get("sign_type");
        String signContent = AliPaySignature.getSignContent(params);
        log.info("sign content: {}", (Object)signContent);
        if ("RSA".equals(signType)) {
            return AliPaySignature.rsaSign(signContent, privateKey);
        }
        if ("RSA2".equals(signType)) {
            return AliPaySignature.rsa256Sign(signContent, privateKey);
        }
        throw new RuntimeException("\u652f\u4ed8\u5b9d\u7b7e\u540d\u65b9\u5f0f\u6709\u8bef");
    }

    public static String getSignContent(Map<String, String> params) {
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (!StringUtils.isNotBlank((CharSequence)key) || !StringUtils.isNotBlank((CharSequence)value)) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        return content.toString();
    }

    public static String rsaSign(String content, String privateKey) {
        try {
            PrivateKey priKey = AliPaySignature.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(priKey);
            signature.update(content.getBytes("UTF-8"));
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64((byte[])signed));
        }
        catch (InvalidKeySpecException ie) {
            throw new RuntimeException("RSA\u79c1\u94a5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u914d\u7f6e\u4e86PKCS8\u683c\u5f0f\u7684\u79c1\u94a5", ie);
        }
        catch (Exception e) {
            throw new RuntimeException("RSAcontent = " + content + "; charset = utf-8", e);
        }
    }

    public static String rsa256Sign(String content, String privateKey) {
        try {
            PrivateKey priKey = AliPaySignature.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(priKey);
            signature.update(content.getBytes("UTF-8"));
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64((byte[])signed));
        }
        catch (Exception e) {
            throw new RuntimeException("RSAcontent = " + content + "; charset = utf-8", e);
        }
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins == null || StringUtils.isEmpty((CharSequence)algorithm)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = StreamUtil.readText(ins).getBytes();
        encodedKey = Base64.decodeBase64((byte[])encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static Boolean verify(Map<String, String> params, String publicKey) {
        return AliPaySignature.rsaCheckV1(params, publicKey, "UTF-8", "RSA2");
    }

    public static String getSignCheckContentV1(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        params.remove("sign_type");
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append((i == 0 ? "" : "&") + key + "=" + value);
        }
        return content.toString();
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64((byte[])encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) {
        try {
            PublicKey pubKey = AliPaySignature.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty((CharSequence)charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64((byte[])sign.getBytes()));
        }
        catch (Exception e) {
            log.trace("RSAcontent = {},sign = {},charset =  {},exception: {}" + charset, new Object[]{content, sign, charset, e});
            return false;
        }
    }

    public static boolean rsa256CheckContent(String content, String sign, String publicKey, String charset) {
        try {
            PublicKey pubKey = AliPaySignature.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty((CharSequence)charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64((byte[])sign.getBytes()));
        }
        catch (Exception e) {
            log.trace("RSAcontent = {},sign = {},charset =  {},exception: {}" + charset, new Object[]{content, sign, charset, e});
            return false;
        }
    }

    public static boolean rsaCheck(String content, String sign, String publicKey, String charset, String signType) {
        if ("RSA".equals(signType)) {
            return AliPaySignature.rsaCheckContent(content, sign, publicKey, charset);
        }
        if ("RSA2".equals(signType)) {
            return AliPaySignature.rsa256CheckContent(content, sign, publicKey, charset);
        }
        log.trace("Sign Type is Not Support : signType= {}", (Object)signType);
        return false;
    }

    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset) {
        String sign = params.get("sign");
        String content = AliPaySignature.getSignCheckContentV1(params);
        return AliPaySignature.rsaCheckContent(content, sign, publicKey, charset);
    }

    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset, String signType) {
        String sign = params.get("sign");
        String content = AliPaySignature.getSignCheckContentV1(params);
        return AliPaySignature.rsaCheck(content, sign, publicKey, charset, signType);
    }
}

