/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.utils;

import com.lly835.bestpay.utils.StringUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;

public class WebUtil {
    public static String buildForm(String baseUrl, Map<String, String> parameters) {
        StringBuffer sb = new StringBuffer();
        sb.append("<form id='bestPayForm' name=\"punchout_form\" method=\"post\" action=\"");
        sb.append(baseUrl);
        sb.append("\">\n");
        sb.append(WebUtil.buildHiddenFields(parameters));
        sb.append("<input type=\"submit\" value=\"\u7acb\u5373\u652f\u4ed8\" style=\"display:none\" >\n");
        sb.append("</form>\n");
        sb.append("<script>document.getElementById('bestPayForm').submit();</script>");
        String form = sb.toString();
        return form;
    }

    private static String buildHiddenFields(Map<String, String> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Set<String> keys = parameters.keySet();
            for (String key : keys) {
                String value = parameters.get(key);
                if (key == null || value == null) continue;
                sb.append(WebUtil.buildHiddenField(key, value));
            }
            String result = sb.toString();
            return result;
        }
        return "";
    }

    private static String buildHiddenField(String key, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("<input type=\"hidden\" name=\"");
        sb.append(key);
        sb.append("\" value=\"");
        String a = value.replace("\"", "&quot;");
        sb.append(a).append("\">\n");
        return sb.toString();
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params != null && !params.isEmpty()) {
            StringBuilder query = new StringBuilder();
            Set<Map.Entry<String, String>> entries = params.entrySet();
            boolean hasParam = false;
            for (Map.Entry<String, String> entry : entries) {
                String value;
                String name = entry.getKey();
                if (!StringUtil.areNotEmpty(name, value = entry.getValue())) continue;
                if (hasParam) {
                    query.append("&");
                } else {
                    hasParam = true;
                }
                query.append(name).append("=").append(URLEncoder.encode(value, charset));
            }
            return query.toString();
        }
        return null;
    }

    public static String getRequestUrl(Map<String, String> parameters, Boolean isSandbox) {
        StringBuffer urlSb = isSandbox != false ? new StringBuffer("https://openapi.alipaydev.com/") : new StringBuffer("https://openapi.alipay.com/");
        urlSb.append("/gateway.do");
        try {
            String charset = null != parameters.get("charset") ? parameters.get("charset") : "utf-8";
            String sysMustQuery = WebUtil.buildQuery(parameters, charset);
            urlSb.append("?");
            urlSb.append(sysMustQuery);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return urlSb.toString();
    }
}

