/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.organization.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.dict.api.DictApi;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.system.api.OrganizationServiceApi;
import cn.stylefeng.roses.kernel.system.api.UserOrgServiceApi;
import cn.stylefeng.roses.kernel.system.api.UserServiceApi;
import cn.stylefeng.roses.kernel.system.api.enums.DetectModeEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.organization.BindUserItem;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserOrgDTO;
import cn.stylefeng.roses.kernel.system.modular.organization.entity.HrOrgApprover;
import cn.stylefeng.roses.kernel.system.modular.organization.enums.HrOrgApproverExceptionEnum;
import cn.stylefeng.roses.kernel.system.modular.organization.mapper.HrOrgApproverMapper;
import cn.stylefeng.roses.kernel.system.modular.organization.pojo.request.HrOrgApproverRequest;
import cn.stylefeng.roses.kernel.system.modular.organization.service.HrOrgApproverService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class HrOrgApproverServiceImpl
extends ServiceImpl<HrOrgApproverMapper, HrOrgApprover>
implements HrOrgApproverService {
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private OrganizationServiceApi organizationServiceApi;
    @Resource
    private UserOrgServiceApi userOrgServiceApi;
    @Resource
    private DictApi dictApi;

    @Override
    public void bindUserList(HrOrgApproverRequest hrOrgApproverRequest) {
        Long orgId = hrOrgApproverRequest.getOrgId();
        Integer orgApproverType = hrOrgApproverRequest.getOrgApproverType();
        List<Long> needToBindUsers = hrOrgApproverRequest.getUserIdList();
        LambdaQueryWrapper hrOrgApproverLambdaQueryWrapper = new LambdaQueryWrapper();
        hrOrgApproverLambdaQueryWrapper.eq(HrOrgApprover::getOrgId, (Object)orgId);
        hrOrgApproverLambdaQueryWrapper.eq(HrOrgApprover::getOrgApproverType, (Object)orgApproverType);
        List alreadyBindUsers = this.list((Wrapper)hrOrgApproverLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)alreadyBindUsers)) {
            ArrayList<HrOrgApprover> tempApprovers = new ArrayList<HrOrgApprover>();
            for (Long userId : needToBindUsers) {
                HrOrgApprover hrOrgApprover = new HrOrgApprover();
                hrOrgApprover.setOrgId(orgId);
                hrOrgApprover.setOrgApproverType(orgApproverType);
                hrOrgApprover.setUserId(userId);
                tempApprovers.add(hrOrgApprover);
            }
            this.saveBatch(tempApprovers);
            return;
        }
        List alreadyBindUserIdList = alreadyBindUsers.stream().map(HrOrgApprover::getUserId).collect(Collectors.toList());
        ArrayList<HrOrgApprover> tempApprovers = new ArrayList<HrOrgApprover>();
        for (Long needToBindUserId : needToBindUsers) {
            boolean needToAdd = true;
            for (Long tempUserId : alreadyBindUserIdList) {
                if (!tempUserId.equals(needToBindUserId)) continue;
                needToAdd = false;
                break;
            }
            if (needToAdd) {
                HrOrgApprover hrOrgApprover = new HrOrgApprover();
                hrOrgApprover.setOrgId(orgId);
                hrOrgApprover.setOrgApproverType(orgApproverType);
                hrOrgApprover.setUserId(needToBindUserId);
                tempApprovers.add(hrOrgApprover);
            }
            this.saveBatch(tempApprovers);
        }
    }

    @Override
    public void del(HrOrgApproverRequest hrOrgApproverRequest) {
        LambdaQueryWrapper hrOrgApproverLambdaQueryWrapper = new LambdaQueryWrapper();
        hrOrgApproverLambdaQueryWrapper.eq(HrOrgApprover::getOrgId, (Object)hrOrgApproverRequest.getOrgId());
        hrOrgApproverLambdaQueryWrapper.eq(HrOrgApprover::getOrgApproverType, (Object)hrOrgApproverRequest.getOrgApproverType());
        hrOrgApproverLambdaQueryWrapper.eq(HrOrgApprover::getUserId, (Object)hrOrgApproverRequest.getUserId());
        this.remove((Wrapper)hrOrgApproverLambdaQueryWrapper);
    }

    @Override
    public HrOrgApprover detail(HrOrgApproverRequest hrOrgApproverRequest) {
        return this.queryHrOrgApprover(hrOrgApproverRequest);
    }

    @Override
    public List<HrOrgApprover> getBindingList(HrOrgApproverRequest hrOrgApproverRequest) {
        List<SimpleDict> approverTypeList = this.getApproverTypeList();
        ArrayList<HrOrgApprover> resultList = new ArrayList<HrOrgApprover>();
        for (SimpleDict orgApproverType : approverTypeList) {
            HrOrgApprover hrOrgApprover = new HrOrgApprover();
            hrOrgApprover.setOrgApproverType(Convert.toInt((Object)orgApproverType.getCode()));
            resultList.add(hrOrgApprover);
        }
        LambdaQueryWrapper hrOrgApproverLambdaQueryWrapper = new LambdaQueryWrapper();
        hrOrgApproverLambdaQueryWrapper.eq(HrOrgApprover::getOrgId, (Object)hrOrgApproverRequest.getOrgId());
        List orgTotalBindingList = this.list((Wrapper)hrOrgApproverLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)orgTotalBindingList)) {
            return resultList;
        }
        Map<Integer, List<HrOrgApprover>> groupingByUsers = orgTotalBindingList.stream().collect(Collectors.groupingBy(HrOrgApprover::getOrgApproverType));
        for (HrOrgApprover hrOrgApprover : resultList) {
            List<HrOrgApprover> userList = groupingByUsers.get(hrOrgApprover.getOrgApproverType());
            if (!ObjectUtil.isNotEmpty(userList)) continue;
            List<BindUserItem> bindUserItems = this.convertUserItem(userList);
            hrOrgApprover.setBindUserItemList(bindUserItems);
        }
        return resultList;
    }

    @Override
    public List<Long> getUserOrgApprover(Long userId, Integer orgApproverType, Integer parentLevel, DetectModeEnum detectModeEnum) {
        SysUserOrgDTO sysUserOrgDTO = this.userOrgServiceApi.getUserOrgByUserId(userId);
        Long orgId = sysUserOrgDTO.getOrgId();
        if (ObjectUtil.isEmpty((Object)orgId)) {
            return new ArrayList<Long>();
        }
        return this.getDeptOrgApprover(orgId, orgApproverType, parentLevel, detectModeEnum);
    }

    @Override
    public List<Long> getDeptOrgApprover(Long deptId, Integer orgApproverType, Integer parentLevel, DetectModeEnum detectModeEnum) {
        Long parentLevelOrgId = this.organizationServiceApi.getParentLevelOrgId(deptId, parentLevel, detectModeEnum);
        if (ObjectUtil.isEmpty((Object)parentLevelOrgId)) {
            return new ArrayList<Long>();
        }
        LambdaQueryWrapper hrOrgApproverLambdaQueryWrapper = new LambdaQueryWrapper();
        hrOrgApproverLambdaQueryWrapper.eq(HrOrgApprover::getOrgId, (Object)parentLevelOrgId);
        hrOrgApproverLambdaQueryWrapper.eq(HrOrgApprover::getOrgApproverType, (Object)orgApproverType);
        List userList = this.list((Wrapper)hrOrgApproverLambdaQueryWrapper);
        return userList.stream().map(HrOrgApprover::getUserId).collect(Collectors.toList());
    }

    @Override
    public List<SimpleDict> getApproverTypeList() {
        return this.dictApi.getDictDetailsByDictTypeCode("org_approver_type");
    }

    private HrOrgApprover queryHrOrgApprover(HrOrgApproverRequest hrOrgApproverRequest) {
        HrOrgApprover hrOrgApprover = (HrOrgApprover)((Object)this.getById(hrOrgApproverRequest.getOrgApproverId()));
        if (ObjectUtil.isEmpty((Object)((Object)hrOrgApprover))) {
            throw new ServiceException((AbstractExceptionEnum)HrOrgApproverExceptionEnum.HR_ORG_APPROVER_NOT_EXISTED);
        }
        return hrOrgApprover;
    }

    private LambdaQueryWrapper<HrOrgApprover> createWrapper(HrOrgApproverRequest hrOrgApproverRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long orgApproverId = hrOrgApproverRequest.getOrgApproverId();
        Integer orgApproverType = hrOrgApproverRequest.getOrgApproverType();
        Long orgId = hrOrgApproverRequest.getOrgId();
        Long userId = hrOrgApproverRequest.getUserId();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)orgApproverId), HrOrgApprover::getOrgApproverId, (Object)orgApproverId);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)orgApproverType), HrOrgApprover::getOrgApproverType, (Object)orgApproverType);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)orgId), HrOrgApprover::getOrgId, (Object)orgId);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userId), HrOrgApprover::getUserId, (Object)userId);
        return queryWrapper;
    }

    private List<BindUserItem> convertUserItem(List<HrOrgApprover> userList) {
        List userIdList = userList.stream().map(HrOrgApprover::getUserId).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(userIdList)) {
            ArrayList<BindUserItem> users = new ArrayList<BindUserItem>();
            for (Long userId : userIdList) {
                BindUserItem bindUserItem = new BindUserItem();
                bindUserItem.setUserId(userId);
                SysUserDTO sysUserDTO = this.userServiceApi.getUserInfoByUserId(userId);
                bindUserItem.setName(sysUserDTO.getRealName());
                bindUserItem.setAvatarUrl(sysUserDTO.getAvatarUrl());
                users.add(bindUserItem);
            }
            return users;
        }
        return new ArrayList<BindUserItem>();
    }
}

